var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var adx;
(function (adx) {
    var sdk;
    (function (sdk) {
        var _ = window["_"];
        var $ = window["$"];
        var Namespace = (function () {
            function Namespace(prefix, uri) {
                this.prefix = prefix;
                this.uri = uri;
            }
            return Namespace;
        })();
        sdk.Namespace = Namespace;
        sdk._xmlns = {
            s: new adx.sdk.Namespace("s", "http://schemas.xmlsoap.org/soap/envelope/"),
            i: new adx.sdk.Namespace("i", "http://www.w3.org/2001/XMLSchema-instance"),
            a: new adx.sdk.Namespace("a", "http://schemas.microsoft.com/xrm/2011/Contracts"),
            b: new adx.sdk.Namespace("b", "http://schemas.datacontract.org/2004/07/System.Collections.Generic"),
            c: new adx.sdk.Namespace("c", "http://www.w3.org/2001/XMLSchema"),
            d: new adx.sdk.Namespace("d", "http://schemas.microsoft.com/xrm/2011/Metadata"),
            e: new adx.sdk.Namespace("e", "http://schemas.microsoft.com/2003/10/Serialization/"),
            f: new adx.sdk.Namespace("f", "http://schemas.microsoft.com/crm/2011/Contracts")
        };
        (function (EntityState) {
            EntityState[EntityState["Unchanged"] = 0] = "Unchanged";
            EntityState[EntityState["Created"] = 1] = "Created";
            EntityState[EntityState["Changed"] = 2] = "Changed";
        })(sdk.EntityState || (sdk.EntityState = {}));
        var EntityState = sdk.EntityState;
        (function (EntityRole) {
            EntityRole[EntityRole["Referencing"] = 0] = "Referencing";
            EntityRole[EntityRole["Referenced"] = 1] = "Referenced";
        })(sdk.EntityRole || (sdk.EntityRole = {}));
        var EntityRole = sdk.EntityRole;
        var ValueProperty = (function () {
            function ValueProperty(value) {
                this.value = value;
            }
            ValueProperty.prototype.toString = function () {
                return this.value;
            };
            ValueProperty.prototype.toSoap = function () {
                return "<a:Value>" + _.escape(this.value) + "</a:Value>";
            };
            return ValueProperty;
        })();
        sdk.ValueProperty = ValueProperty;
        var Guid = (function (_super) {
            __extends(Guid, _super);
            function Guid(value) {
                _super.call(this, value);
            }
            Guid.prototype.toSoap = function () {
                return _.escape(this.value);
            };
            Guid.empty = new Guid("00000000-0000-0000-0000-000000000000");
            Guid._namespace = adx.sdk._xmlns.e;
            Guid._soapType = "guid";
            return Guid;
        })(ValueProperty);
        sdk.Guid = Guid;
        var DateTime = (function (_super) {
            __extends(DateTime, _super);
            function DateTime(value) {
                _super.call(this, value);
            }
            DateTime.prototype.toDate = function () {
                return new Date(Date.parse(this.value));
            };
            DateTime.prototype.toSoap = function () {
                return _.escape(this.value);
            };
            DateTime._namespace = adx.sdk._xmlns.c;
            DateTime._soapType = "dateTime";
            return DateTime;
        })(ValueProperty);
        sdk.DateTime = DateTime;
        var Decimal = (function (_super) {
            __extends(Decimal, _super);
            function Decimal(value) {
                _super.call(this, value);
            }
            Decimal.prototype.toSoap = function () {
                return this.value.toString();
            };
            Decimal._namespace = adx.sdk._xmlns.c;
            Decimal._soapType = "decimal";
            return Decimal;
        })(ValueProperty);
        sdk.Decimal = Decimal;
        var Double = (function (_super) {
            __extends(Double, _super);
            function Double(value) {
                _super.call(this, value);
            }
            Double.prototype.toSoap = function () {
                return this.value.toString();
            };
            Double._namespace = adx.sdk._xmlns.c;
            Double._soapType = "double";
            return Double;
        })(ValueProperty);
        sdk.Double = Double;
        var Int = (function (_super) {
            __extends(Int, _super);
            function Int(value) {
                _super.call(this, value);
            }
            Int.prototype.toSoap = function () {
                return this.value.toString();
            };
            Int._namespace = adx.sdk._xmlns.c;
            Int._soapType = "int";
            return Int;
        })(ValueProperty);
        sdk.Int = Int;
        var Long = (function (_super) {
            __extends(Long, _super);
            function Long(value) {
                _super.call(this, value);
            }
            Long.prototype.toSoap = function () {
                return this.value.toString();
            };
            Long._namespace = adx.sdk._xmlns.c;
            Long._soapType = "long";
            return Long;
        })(ValueProperty);
        sdk.Long = Long;
        var Money = (function (_super) {
            __extends(Money, _super);
            function Money(value) {
                _super.call(this, value);
            }
            Money._namespace = adx.sdk._xmlns.a;
            return Money;
        })(ValueProperty);
        sdk.Money = Money;
        var OptionSetValue = (function (_super) {
            __extends(OptionSetValue, _super);
            function OptionSetValue(value) {
                _super.call(this, value);
            }
            OptionSetValue._namespace = adx.sdk._xmlns.a;
            return OptionSetValue;
        })(ValueProperty);
        sdk.OptionSetValue = OptionSetValue;
        var EntityReference = (function () {
            function EntityReference(logicalName, id, name) {
                if (logicalName === void 0) { logicalName = null; }
                if (id === void 0) { id = Guid.empty.value; }
                if (name === void 0) { name = null; }
                this.logicalName = logicalName;
                this.id = id;
                this.name = name;
            }
            EntityReference.prototype.equals = function (obj) {
                if (!obj)
                    return false;
                if (this === obj)
                    return true;
                return this.id == obj.id && this.logicalName == obj.logicalName;
            };
            EntityReference.prototype.toSoap = function () {
                return [
                    "<a:Id>" + _.escape(this.id) + "</a:Id>",
                    "<a:LogicalName>" + _.escape(this.logicalName) + "</a:LogicalName>",
                    (this.name ? "<a:Name>" + _.escape(this.name) + "</a:Name>" : "<a:Name i:nil='true' />"),
                ].join("");
            };
            EntityReference._namespace = adx.sdk._xmlns.a;
            return EntityReference;
        })();
        sdk.EntityReference = EntityReference;
        var EntityReferenceCollection = (function () {
            function EntityReferenceCollection(items) {
                this.items = items;
            }
            EntityReferenceCollection.prototype.toSoap = function () {
                return _.map(this.items, function (item) { return "<a:EntityReference>" + item.toSoap() + "</a:EntityReference>"; }).join("");
            };
            EntityReferenceCollection._namespace = adx.sdk._xmlns.a;
            return EntityReferenceCollection;
        })();
        sdk.EntityReferenceCollection = EntityReferenceCollection;
        var Base64Binary = (function (_super) {
            __extends(Base64Binary, _super);
            function Base64Binary(value) {
                _super.call(this, value);
            }
            Base64Binary.prototype.toSoap = function () {
                return _.escape(this.value);
            };
            Base64Binary._namespace = adx.sdk._xmlns.c;
            Base64Binary._soapType = "base64Binary";
            return Base64Binary;
        })(ValueProperty);
        sdk.Base64Binary = Base64Binary;
        var Relationship = (function () {
            function Relationship(schemaName, primaryEntityRole) {
                if (primaryEntityRole === void 0) { primaryEntityRole = null; }
                this.schemaName = schemaName;
                this.primaryEntityRole = primaryEntityRole;
            }
            Relationship.prototype.toSoap = function () {
                return [
                    (this.primaryEntityRole ? "<a:PrimaryEntityRole>" + _.escape(this.primaryEntityRole) + "</a:PrimaryEntityRole>" : "<a:PrimaryEntityRole i:nil='true' />"),
                    "<a:SchemaName>" + _.escape(this.schemaName) + "</a:SchemaName>",
                ].join("");
            };
            Relationship._namespace = adx.sdk._xmlns.a;
            return Relationship;
        })();
        sdk.Relationship = Relationship;
        var SoapCollection = (function () {
            function SoapCollection() {
            }
            SoapCollection.prototype.toSoapFromCollection = function (collection) {
                var _this = this;
                return _.map(collection, function (value, key) {
                    return _this.toSoapFromEntry(key, value);
                }).join("");
            };
            SoapCollection.prototype.toParameterType = function (key, value) {
                return adx.sdk.util.getType(value);
            };
            SoapCollection.prototype.toParameterNamespace = function (key, value) {
                return adx.sdk.util.getNamespace(value);
            };
            SoapCollection.prototype.toParameterValue = function (key, value, type) {
                if (typeof (value.toSoap) === "function") {
                    return value.toSoap();
                }
                return _.escape(value);
            };
            SoapCollection.prototype.toSoapFromEntry = function (key, value) {
                return [
                    "<a:KeyValuePairOfstringanyType>",
                    "<b:key>" + _.escape(key) + "</b:key>",
                    this.toSoapFromValue(key, value),
                    "</a:KeyValuePairOfstringanyType>",
                ].join("");
            };
            SoapCollection.prototype.toSoapFromValue = function (key, value) {
                if (value == null)
                    return "<b:value i:nil='true'/>";
                var type = this.toParameterType(key, value);
                var xmlns = this.toParameterNamespace(key, value) || adx.sdk._xmlns.c;
                var soapValue = this.toParameterValue(key, value, type);
                if (adx.sdk.util.contains(["s", "i", "a", "b"], xmlns.prefix)) {
                    return "<b:value i:type='" + _.escape(xmlns.prefix) + ":" + _.escape(type) + "'>" + soapValue + "</b:value>";
                }
                else {
                    return "<b:value i:type='" + _.escape(xmlns.prefix) + ":" + _.escape(type) + "' xmlns:" + _.escape(xmlns.prefix) + "='" + _.escape(xmlns.uri) + "'>" + soapValue + "</b:value>";
                }
            };
            return SoapCollection;
        })();
        sdk.SoapCollection = SoapCollection;
        var Entity = (function (_super) {
            __extends(Entity, _super);
            function Entity(logicalName, id) {
                if (logicalName === void 0) { logicalName = null; }
                if (id === void 0) { id = Guid.empty.value; }
                _super.call(this);
                this.logicalName = logicalName;
                this.id = id;
                this.attributes = {};
                this.formattedValues = {};
            }
            Entity.prototype.toEntityReference = function () {
                return new EntityReference(this.logicalName, this.id);
            };
            Entity.prototype.toSoap = function () {
                return [
                    this.toSoapFromAttributes(this.attributes),
                    (this.entityState ? "<a:EntityState>" + _.escape(this.entityState) + "</a:EntityState>" : "<a:EntityState i:nil='true' />"),
                    "<a:FormattedValues />",
                    "<a:Id>" + _.escape(this.id) + "</a:Id>",
                    "<a:LogicalName>" + _.escape(this.logicalName) + "</a:LogicalName>",
                    "<a:RelatedEntities />",
                ].join("");
            };
            Entity.prototype.toSoapFromAttributes = function (attributes) {
                return [
                    "<a:Attributes>",
                    this.toSoapFromCollection(attributes),
                    "</a:Attributes>",
                ].join("");
            };
            Entity.prototype.fromJson = function (data) {
                adx.sdk.util.fromJsonKeyValuePairs(this, data, "attributes");
                adx.sdk.util.fromJsonKeyValuePairs(this, data, "formattedValues");
                adx.sdk.util.fromJsonKeyValuePairs(this, data, "relatedEntities");
            };
            Entity.prototype.toEntity = function (metadata) {
                var _this = this;
                if (metadata === void 0) { metadata = null; }
                var attributes = _.map(this.attributes, function (value, key) { return [key, _this.fixData(metadata == null ? null : metadata.getAttribute(key), value)]; });
                var entity = new Entity();
                entity.logicalName = this.logicalName;
                entity.id = this.id;
                entity.entityState = this.entityState;
                entity.formattedValues = _.clone(this.formattedValues);
                entity.attributes = _.object(attributes);
                return entity;
            };
            Entity.prototype.fixData = function (metadata, value) {
                if (!metadata) {
                    return value;
                }
                switch (metadata.attributeType) {
                    case adx.sdk.metadata.AttributeTypeCode.Boolean:
                        return value;
                    case adx.sdk.metadata.AttributeTypeCode.Lookup:
                    case adx.sdk.metadata.AttributeTypeCode.Customer:
                    case adx.sdk.metadata.AttributeTypeCode.Owner:
                        return new adx.sdk.EntityReference(value["LogicalName"], value["Id"], value["Name"]);
                    case adx.sdk.metadata.AttributeTypeCode.DateTime:
                        return new adx.sdk.DateTime(value);
                    case adx.sdk.metadata.AttributeTypeCode.Decimal:
                        return new adx.sdk.Decimal(value);
                    case adx.sdk.metadata.AttributeTypeCode.Double:
                        return new adx.sdk.Double(value);
                    case adx.sdk.metadata.AttributeTypeCode.Integer:
                        return new adx.sdk.Int(value);
                    case adx.sdk.metadata.AttributeTypeCode.Money:
                        return new adx.sdk.Money(value["Value"]);
                    case adx.sdk.metadata.AttributeTypeCode.Picklist:
                    case adx.sdk.metadata.AttributeTypeCode.State:
                    case adx.sdk.metadata.AttributeTypeCode.Status:
                        return new adx.sdk.OptionSetValue(value["Value"]);
                    case adx.sdk.metadata.AttributeTypeCode.Uniqueidentifier:
                        return new adx.sdk.Guid(value);
                    case adx.sdk.metadata.AttributeTypeCode.BigInt:
                        return new adx.sdk.Long(value);
                    case adx.sdk.metadata.AttributeTypeCode.PartyList:
                        var collection = value;
                        if (collection) {
                            collection.entities = _.map(collection.entities, function (item) { return item.toEntity(adx.sdk.metadata._activityPartyMetadata); });
                            return collection;
                        }
                }
                return value;
            };
            Entity._namespace = adx.sdk._xmlns.a;
            return Entity;
        })(SoapCollection);
        sdk.Entity = Entity;
        var EntityCollection = (function () {
            function EntityCollection(entities) {
                if (entities === void 0) { entities = null; }
                this.entities = entities;
            }
            EntityCollection.prototype.toSoap = function () {
                return [
                    '<a:Entities>',
                    this.toSoapFromEntities(),
                    '</a:Entities>'
                ].join("");
            };
            EntityCollection.prototype.toSoapFromEntities = function () {
                return _.map(this.entities, function (item) { return "<a:Entity>" + item.toSoap() + "</a:Entity>"; }).join("");
            };
            EntityCollection.prototype.fromSoap = function (data) {
                adx.sdk.util.fromSoapArrayProperty(this, data, "entities", "Entity");
            };
            EntityCollection._namespace = adx.sdk._xmlns.a;
            return EntityCollection;
        })();
        sdk.EntityCollection = EntityCollection;
        var FaultException = (function () {
            function FaultException(faultCode, faultString, detail) {
                this.faultCode = faultCode;
                this.faultString = faultString;
                this.detail = detail;
            }
            return FaultException;
        })();
        sdk.FaultException = FaultException;
        var BaseServiceFault = (function () {
            function BaseServiceFault(errorCode, message, timestamp, errorDetails) {
                this.errorCode = errorCode;
                this.message = message;
                this.timestamp = timestamp;
                this.errorDetails = errorDetails;
            }
            return BaseServiceFault;
        })();
        sdk.BaseServiceFault = BaseServiceFault;
        var OrganizationServiceFault = (function (_super) {
            __extends(OrganizationServiceFault, _super);
            function OrganizationServiceFault(errorCode, message, timestamp, errorDetails, traceText, innerFault) {
                _super.call(this, errorCode, message, timestamp, errorDetails);
                this.timestamp = timestamp;
                this.traceText = traceText;
                this.innerFault = innerFault;
                this.unsignedErrorCode = errorCode >>> 0;
                this.unsignedHexErrorCode = "0x" + this.unsignedErrorCode.toString(16);
            }
            return OrganizationServiceFault;
        })(BaseServiceFault);
        sdk.OrganizationServiceFault = OrganizationServiceFault;
        var ExceptionDetail = (function () {
            function ExceptionDetail(helpLink, message, stackTrace, type, innerException) {
                this.helpLink = helpLink;
                this.message = message;
                this.stackTrace = stackTrace;
                this.type = type;
                this.innerException = innerException;
            }
            return ExceptionDetail;
        })();
        sdk.ExceptionDetail = ExceptionDetail;
        var util;
        (function (util) {
            function contains(array, obj) {
                var i = array.length;
                while (i--) {
                    if (array[i] === obj) {
                        return true;
                    }
                }
                return false;
            }
            util.contains = contains;
            ;
            function toCamelCase(s) {
                return s.replace(/(\w)(\w*)/g, function (s) {
                    var args = [];
                    for (var _i = 1; _i < arguments.length; _i++) {
                        args[_i - 1] = arguments[_i];
                    }
                    return args[0].toLowerCase() + args[1];
                });
            }
            util.toCamelCase = toCamelCase;
            function toPascalCase(s) {
                return s.replace(/(\w)(\w*)/g, function (s) {
                    var args = [];
                    for (var _i = 1; _i < arguments.length; _i++) {
                        args[_i - 1] = arguments[_i];
                    }
                    return args[0].toUpperCase() + args[1];
                });
            }
            util.toPascalCase = toPascalCase;
            function getType(obj) {
                if (typeof (obj) === "number")
                    return "double";
                var primitive = _.first(_.filter(["string", "boolean"], function (type) { return typeof (obj) === type; }));
                if (primitive)
                    return primitive;
                if (typeof (obj.constructor._soapType) != "undefined")
                    return obj.constructor._soapType;
                var results = /function (.{1,})\(/.exec(obj.constructor.toString());
                return (results && results.length > 1) ? results[1] : null;
            }
            util.getType = getType;
            ;
            function getNamespace(obj) {
                return obj.constructor._namespace;
            }
            util.getNamespace = getNamespace;
            function enumToString(value, type) {
                var result = [];
                for (var n = 1; n <= value; n <<= 1) {
                    if (n & value)
                        result.push(type[n]);
                }
                return result.join(" ");
            }
            util.enumToString = enumToString;
            var _propertyTypeMap = [
                { properties: ["Attributes", "PrimaryIdAttribute"], create: function () { return new adx.sdk.metadata.EntityMetadata(); } },
                { properties: ["ManagedPropertyLogicalName", "Value"], create: function () { return new adx.sdk.metadata.BooleanManagedProperty(null, null); } },
                { properties: ["LocalizedLabels", "UserLocalizedLabel"], create: function () { return new adx.sdk.metadata.Label(); } },
                { properties: ["Label", "LanguageCode", "IsManaged"], create: function () { return new adx.sdk.metadata.LocalizedLabel(); } },
                { properties: ["EntityLogicalName", "AttributeType"], create: function () { return new adx.sdk.metadata.AttributeMetadata(); } },
                { properties: ["OptionSetType", "Options"], create: function () { return new adx.sdk.metadata.OptionSetMetadata(); } },
                { properties: ["OptionSetType", "TrueOption", "FalseOption"], create: function () { return new adx.sdk.metadata.BooleanOptionSetMetadata(); } },
                { properties: ["PrivilegeId", "PrivilegeType"], create: function () { return new adx.sdk.metadata.SecurityPrivilegeMetadata(); } },
                { properties: ["Behavior", "Group", "Order"], create: function () { return new adx.sdk.metadata.AssociatedMenuConfiguration(); } },
                { properties: ["Assign", "Share"], create: function () { return new adx.sdk.metadata.CascadeConfiguration(); } },
                { properties: ["ReferencedEntity", "ReferencingEntity"], create: function () { return new adx.sdk.metadata.OneToManyRelationshipMetadata(); } },
                { properties: ["Entity1IntersectAttribute", "Entity2IntersectAttribute"], create: function () { return new adx.sdk.metadata.ManyToManyRelationshipMetadata(); } },
                { properties: ["Value", "Label", "Description", "IsManaged", "DefaultStatus"], create: function () { return new adx.sdk.metadata.StateOptionMetadata(); } },
                { properties: ["Value", "Label", "Description", "IsManaged", "State"], create: function () { return new adx.sdk.metadata.StatusOptionMetadata(); } },
                { properties: ["Value", "Label", "Description", "IsManaged"], create: function () { return new adx.sdk.metadata.OptionMetadata(); } },
                { properties: ["Attributes", "Id", "LogicalName"], create: function () { return new adx.sdk.Entity(); } },
                { properties: ["Entities", "PagingCookie"], create: function () { return new adx.sdk.EntityCollection(); } },
            ];
            function fromJson(data) {
                if (data instanceof Array) {
                    return _.map(data, function (item) { return fromJson(item); });
                }
                if (data instanceof Object) {
                    var propertyType = _.find(_propertyTypeMap, function (item) { return hasPropertiesFromJson(data, item.properties); });
                    if (propertyType) {
                        var raw = propertyType.create();
                        var value = fromJsonMapped(data, raw);
                        return setPropertiesFromJson(value, data);
                    }
                }
                return data;
            }
            util.fromJson = fromJson;
            function fromJsonMapped(data, raw) {
                if (raw instanceof adx.sdk.metadata.AttributeMetadata) {
                    return fromJsonAttributeMetadata(data["AttributeType"]);
                }
                if (raw instanceof adx.sdk.metadata.ManagedProperty) {
                    if (typeof (data["Value"]) == "boolean") {
                        return new adx.sdk.metadata.BooleanManagedProperty();
                    }
                    else if (typeof (data["Value"]) == "number") {
                        return new adx.sdk.metadata.AttributeRequiredLevelManagedProperty();
                    }
                }
                return raw;
            }
            function fromJsonAttributeMetadata(code) {
                switch (code) {
                    case adx.sdk.metadata.AttributeTypeCode.EntityName:
                        return new adx.sdk.metadata.EntityNameAttributeMetadata();
                    case adx.sdk.metadata.AttributeTypeCode.Boolean:
                        return new adx.sdk.metadata.BooleanAttributeMetadata();
                    case adx.sdk.metadata.AttributeTypeCode.DateTime:
                        return new adx.sdk.metadata.DateTimeAttributeMetadata();
                    case adx.sdk.metadata.AttributeTypeCode.Decimal:
                        return new adx.sdk.metadata.DecimalAttributeMetadata();
                    case adx.sdk.metadata.AttributeTypeCode.Double:
                        return new adx.sdk.metadata.DoubleAttributeMetadata();
                    case adx.sdk.metadata.AttributeTypeCode.Money:
                        return new adx.sdk.metadata.MoneyAttributeMetadata();
                    case adx.sdk.metadata.AttributeTypeCode.Integer:
                        return new adx.sdk.metadata.IntegerAttributeMetadata();
                    case adx.sdk.metadata.AttributeTypeCode.BigInt:
                        return new adx.sdk.metadata.BigIntAttributeMetadata();
                    case adx.sdk.metadata.AttributeTypeCode.Lookup:
                        return new adx.sdk.metadata.LookupAttributeMetadata();
                    case adx.sdk.metadata.AttributeTypeCode.Owner:
                        return new adx.sdk.metadata.LookupAttributeMetadata();
                    case adx.sdk.metadata.AttributeTypeCode.PartyList:
                        return new adx.sdk.metadata.LookupAttributeMetadata();
                    case adx.sdk.metadata.AttributeTypeCode.Customer:
                        return new adx.sdk.metadata.LookupAttributeMetadata();
                    case adx.sdk.metadata.AttributeTypeCode.Memo:
                        return new adx.sdk.metadata.MemoAttributeMetadata();
                    case adx.sdk.metadata.AttributeTypeCode.Status:
                        return new adx.sdk.metadata.StatusAttributeMetadata();
                    case adx.sdk.metadata.AttributeTypeCode.Picklist:
                        return new adx.sdk.metadata.PicklistAttributeMetadata();
                    case adx.sdk.metadata.AttributeTypeCode.ManagedProperty:
                        return new adx.sdk.metadata.ManagedPropertyAttributeMetadata();
                    case adx.sdk.metadata.AttributeTypeCode.State:
                        return new adx.sdk.metadata.StateAttributeMetadata();
                    case adx.sdk.metadata.AttributeTypeCode.String:
                        return new adx.sdk.metadata.StringAttributeMetadata();
                }
                return new adx.sdk.metadata.AttributeMetadata();
            }
            function setPropertiesFromJson(obj, data) {
                // give the object a chance to perform custom property initialization
                if (typeof (obj["fromJson"]) === "function") {
                    obj["fromJson"](data);
                }
                _.each(data, function (value, key) { return setPropertyFromJson(obj, key, value); });
                return obj;
            }
            function setPropertyFromJson(obj, key, value) {
                // ignore flagged properties
                if (value instanceof Object && value["_skip"])
                    return;
                obj[toCamelCase(key)] = fromJson(value);
            }
            function hasPropertiesFromJson(obj, properties) {
                return _.every(properties, function (property) { return typeof (obj[property]) != "undefined"; });
            }
            function fromSoap(data) {
                var nil = data["@i:nil"];
                if (nil == "true") {
                    return null;
                }
                var type = data["_type"];
                if (typeof (type) != "undefined") {
                    if (type.name == "ArrayOfEntityMetadata") {
                        return _.map(data["EntityMetadata"], function (item) { return fromSoap(item); });
                    }
                    if (type.name == "string") {
                        return data["#text"];
                    }
                    if (type.name == "boolean") {
                        return data["#text"];
                    }
                    if (type.name == "double") {
                        return data["#text"];
                    }
                    if (type.name == "dateTime") {
                        return new adx.sdk.DateTime(data["#text"]);
                    }
                    if (type.name == "guid") {
                        return new adx.sdk.Guid(data["#text"]);
                    }
                    if (type.name == "decimal") {
                        return new adx.sdk.Decimal(data["#text"]);
                    }
                    if (type.name == "int") {
                        return new adx.sdk.Int(data["#text"]);
                    }
                    if (type.name == "long") {
                        return new adx.sdk.Long(data["#text"]);
                    }
                    if (typeof (data["@i:type"]) != "undefined") {
                        var loader = new InstanceLoader(type.uri);
                        var value = loader.getInstance(type.name);
                        if (value) {
                            return setPropertiesFromSoap(value, data);
                        }
                    }
                }
                if (hasPropertiesFromSoap(data, ["KeyValuePairOfstringanyType"])) {
                    return _.object(_.map(_.filter(data["KeyValuePairOfstringanyType"], function (item) { return item instanceof Object; }), function (item) { return [fromSoap(item.key[0]), fromSoap(item.value[0])]; }));
                }
                if (hasPropertiesFromSoap(data, ["KeyValuePairOfstringstring"])) {
                    return _.object(_.map(_.filter(data["KeyValuePairOfstringstring"], function (item) { return item instanceof Object; }), function (item) { return [fromSoap(item.key[0]), fromSoap(item.value[0])]; }));
                }
                var propertyType = _.find(_propertyTypeMap, function (item) { return hasPropertiesFromSoap(data, item.properties); });
                if (propertyType) {
                    return setPropertiesFromSoap(propertyType.create(), data);
                }
                var text = data["#text"];
                if (typeof (text) != "undefined") {
                    return text;
                }
                if (_.some(data, function (item) { return item instanceof Array; })) {
                    if (window.console && window.console.warn) {
                        window.console.warn(data);
                    }
                }
            }
            util.fromSoap = fromSoap;
            function setPropertiesFromSoap(obj, data) {
                // give the object a chance to perform custom property initialization
                if (typeof (obj["fromSoap"]) === "function") {
                    obj["fromSoap"](data);
                }
                _.each(_.filter(data, function (item) { return item instanceof Array; }), function (item) { return setPropertyFromSoap(obj, item[0]); });
                return obj;
            }
            function setPropertyFromSoap(obj, data) {
                // ignore flagged properties
                if (data["_skip"])
                    return;
                var type = data["_type"];
                if (typeof (type) != "undefined") {
                    obj[toCamelCase(type.name)] = fromSoap(data);
                }
            }
            function hasPropertiesFromSoap(obj, properties) {
                return _.every(properties, function (property) { return obj[property] instanceof Array; });
            }
            function fromJsonKeyValuePairs(obj, data, attribute) {
                var key = toPascalCase(attribute);
                if (_.has(data, key)) {
                    var node = data[key];
                    var pairs = _.map(node, function (item) { return [item["Key"], fromJson(item["Value"])]; });
                    obj[attribute] = _.object(pairs);
                    node["_skip"] = true;
                }
            }
            util.fromJsonKeyValuePairs = fromJsonKeyValuePairs;
            function fromSoapArrayProperty(obj, data, attribute, type) {
                var key = toPascalCase(attribute);
                if (_.has(data, key)) {
                    var node = data[key][0];
                    obj[attribute] = _.map(_.filter(node[type], function (item) { return item instanceof Object; }), function (item) { return fromSoap(item); });
                    node["_skip"] = true;
                }
            }
            util.fromSoapArrayProperty = fromSoapArrayProperty;
            function fromSoapBoolean(obj, data) {
                var attributes = [];
                for (var _i = 2; _i < arguments.length; _i++) {
                    attributes[_i - 2] = arguments[_i];
                }
                _.each(attributes, function (attribute) {
                    var key = toPascalCase(attribute);
                    if (_.has(data, key)) {
                        var node = data[key][0];
                        obj[attribute] = fromSoap(node) == "true";
                        node["_skip"] = true;
                    }
                });
            }
            util.fromSoapBoolean = fromSoapBoolean;
            function fromSoapNumber(obj, data) {
                var attributes = [];
                for (var _i = 2; _i < arguments.length; _i++) {
                    attributes[_i - 2] = arguments[_i];
                }
                _.each(attributes, function (attribute) {
                    var key = toPascalCase(attribute);
                    if (_.has(data, key)) {
                        var node = data[key][0];
                        obj[attribute] = +fromSoap(node);
                        node["_skip"] = true;
                    }
                });
            }
            util.fromSoapNumber = fromSoapNumber;
            function fromSoapEnum(obj, data, attribute, type) {
                var key = toPascalCase(attribute);
                if (_.has(data, key)) {
                    var node = data[key][0];
                    obj[attribute] = type[fromSoap(node)];
                    node["_skip"] = true;
                }
            }
            util.fromSoapEnum = fromSoapEnum;
            function fromSoapObject(obj, data, attribute, value) {
                var key = toPascalCase(attribute);
                if (_.has(data, key)) {
                    var node = data[key][0];
                    obj[attribute] = value;
                    setPropertiesFromSoap(value, node);
                    node["_skip"] = true;
                }
            }
            util.fromSoapObject = fromSoapObject;
            var _namespaces = null;
            var InstanceLoader = (function () {
                function InstanceLoader(uri) {
                    this.uri = uri;
                    if (_namespaces == null) {
                        var namespaces = {};
                        this.loadNamespaces(namespaces, adx);
                        _namespaces = namespaces;
                    }
                }
                InstanceLoader.prototype.getInstance = function (name) {
                    var args = [];
                    for (var _i = 1; _i < arguments.length; _i++) {
                        args[_i - 1] = arguments[_i];
                    }
                    var context = _namespaces[this.uri + " " + name];
                    if (context) {
                        var instance = Object.create(context[name].prototype);
                        instance.constructor.apply(instance, args);
                        return instance;
                    }
                    return null;
                };
                InstanceLoader.prototype.loadNamespaces = function (namespaces, context) {
                    var _this = this;
                    _.each(_.filter(context, function (item) { return item instanceof Object; }), function (item) {
                        var ns = item._namespace;
                        if (typeof (ns) != "undefined") {
                            var results = /function (.{1,})\(/.exec(item.toString());
                            var name = (results && results.length > 1) ? results[1] : null;
                            namespaces[ns.uri + " " + name] = context;
                        }
                        else {
                            _this.loadNamespaces(namespaces, item);
                        }
                    });
                };
                return InstanceLoader;
            })();
            util.InstanceLoader = InstanceLoader;
        })(util = sdk.util || (sdk.util = {}));
        var client;
        (function (client) {
            var OrganizationService = (function () {
                function OrganizationService() {
                }
                OrganizationService.prototype.execute = function (request) {
                    var _this = this;
                    var url = this.getCrmClientOrgUrl();
                    var data = request.toSoapEnvelope();
                    var response;
                    $.ajax({
                        async: false,
                        type: "POST",
                        contentType: "application/xml, charset=utf-8",
                        datatype: "xml",
                        url: url,
                        data: data,
                        beforeSend: function (jqXHR) {
                            jqXHR.setRequestHeader("Accept", "application/xml, text/xml, */*");
                            jqXHR.setRequestHeader("Content-Type", "text/xml; charset=utf-8");
                            jqXHR.setRequestHeader("SOAPAction", "http://schemas.microsoft.com/xrm/2011/Contracts/Services/IOrganizationService/Execute");
                        }
                    }).done(function (doc, textStatus, jqXHR) { response = _this.toResponse(doc); }).fail(function (jqXHR, textStatus, errorThrown) { return _this.onFault(jqXHR, textStatus, errorThrown); });
                    return response;
                };
                OrganizationService.prototype.executeAsync = function (request) {
                    var _this = this;
                    var url = this.getCrmClientOrgUrl();
                    var data = request.toSoapEnvelope();
                    return $.ajax({
                        async: true,
                        type: "POST",
                        contentType: "application/xml, charset=utf-8",
                        datatype: "xml",
                        url: url,
                        data: data,
                        beforeSend: function (jqXHR) {
                            jqXHR.setRequestHeader("Accept", "application/xml, text/xml, */*");
                            jqXHR.setRequestHeader("Content-Type", "text/xml; charset=utf-8");
                            jqXHR.setRequestHeader("SOAPAction", "http://schemas.microsoft.com/xrm/2011/Contracts/Services/IOrganizationService/Execute");
                        }
                    }).then(function (doc, textStatus, jqXHR) { return _this.toResponse(doc); }, function (jqXHR, textStatus, errorThrown) { return _this.toFault(jqXHR.responseText, textStatus); });
                };
                OrganizationService.prototype.retrieveMultipleAsync = function (query) {
                    var request = new adx.sdk.messages.RetrieveMultipleRequest(query);
                    return this.executeAsync(request).then(function (response) { return response.getEntityCollection(); });
                };
                OrganizationService.prototype.fetchAsync = function (query) {
                    return this.retrieveMultipleAsync(new adx.sdk.query.FetchExpression(query));
                };
                OrganizationService.prototype.retrieveAsync = function (entityName, id, columnSet) {
                    if (columnSet === void 0) { columnSet = null; }
                    var request = new adx.sdk.messages.RetrieveRequest(new adx.sdk.EntityReference(entityName, id), columnSet);
                    return this.executeAsync(request).then(function (response) { return response.getEntity(); });
                };
                OrganizationService.prototype.createAsync = function (entity) {
                    var request = new adx.sdk.messages.CreateRequest(entity);
                    return this.executeAsync(request).then(function (response) { return response.getId(); });
                };
                OrganizationService.prototype.toResponse = function (doc) {
                    var json = this.toObject({}, doc);
                    var data = json["Envelope"][0]["Body"][0]["ExecuteResponse"][0]["ExecuteResult"][0];
                    return adx.sdk.util.fromSoap(data);
                };
                OrganizationService.prototype.onFault = function (jqXHR, textStatus, errorThrown) {
                    var fault = this.toFault(jqXHR.responseText, textStatus);
                    throw fault;
                };
                OrganizationService.prototype.toFault = function (responseText, textStatus) {
                    if (!responseText || responseText == "") {
                        return this.toException(null, null, textStatus);
                    }
                    var doc = $.parseXML(responseText);
                    var json = this.toObject({}, doc);
                    var fault = json["Envelope"][0]["Body"][0]["Fault"][0];
                    var faultCode = adx.sdk.util.fromSoap(fault["faultcode"][0]);
                    var faultString = adx.sdk.util.fromSoap(fault["faultstring"][0]);
                    var exception = this.toException(fault["detail"][0], faultCode, faultString);
                    return exception;
                };
                OrganizationService.prototype.toException = function (data, faultCode, faultString) {
                    if (data && _.has(data, "OrganizationServiceFault")) {
                        var orgFault = this.toOrganizationServiceFault(data["OrganizationServiceFault"][0]);
                        return new adx.sdk.FaultException(faultCode, faultString, orgFault);
                    }
                    if (data && _.has(data, "ExceptionDetail")) {
                        var detail = this.toExceptionDetail(data["ExceptionDetail"][0]);
                        return new adx.sdk.FaultException(faultCode, faultString, detail);
                    }
                    return new adx.sdk.FaultException(faultCode, faultString, data);
                };
                OrganizationService.prototype.toExceptionDetail = function (data) {
                    var nil = data["@i:nil"];
                    if (nil == "true") {
                        return null;
                    }
                    var helpLink = adx.sdk.util.fromSoap(data["HelpLink"][0]);
                    var message = adx.sdk.util.fromSoap(data["Message"][0]);
                    var stackTrace = adx.sdk.util.fromSoap(data["StackTrace"][0]);
                    var type = adx.sdk.util.fromSoap(data["Type"][0]);
                    var innerException = this.toExceptionDetail(data["InnerException"][0]);
                    return new adx.sdk.ExceptionDetail(helpLink, message, stackTrace, type, innerException);
                };
                OrganizationService.prototype.toOrganizationServiceFault = function (data) {
                    var nil = data["@i:nil"];
                    if (nil == "true") {
                        return null;
                    }
                    var errorCode = adx.sdk.util.fromSoap(data["ErrorCode"][0]);
                    var message = adx.sdk.util.fromSoap(data["Message"][0]);
                    var timestamp = adx.sdk.util.fromSoap(data["Timestamp"][0]);
                    var traceText = adx.sdk.util.fromSoap(data["TraceText"][0]);
                    var errorDetails = adx.sdk.util.fromSoap(data["ErrorDetails"][0]);
                    var innerFault = this.toOrganizationServiceFault(data["InnerFault"][0]);
                    return new adx.sdk.OrganizationServiceFault(errorCode, message, timestamp, errorDetails, traceText, innerFault);
                };
                OrganizationService.prototype.toObject = function (namespaces, node) {
                    var nodeName = this.getXmlName(node.localName || node.nodeName);
                    var obj = { _name: nodeName.name };
                    // convert attributes
                    var ns = this.setAttributes(obj, node);
                    var merged = _.extend(ns, namespaces);
                    //obj["_ns"] = merged;
                    var type = obj["@i:type"];
                    var xmlName = typeof (type) != "undefined"
                        ? this.getXmlName(type)
                        : nodeName;
                    obj["_type"] = { ns: xmlName.ns, name: xmlName.name, uri: merged[xmlName.ns] };
                    // convert child elements
                    var children = this.setChildren(merged, obj, node);
                    return obj;
                };
                OrganizationService.prototype.setAttributes = function (obj, node) {
                    var _this = this;
                    var namespaces = {};
                    if (node.nodeType == 1 && node.attributes.length > 0) {
                        _.each(node.attributes, function (attribute) { return _this.setAttribute(namespaces, obj, attribute); });
                    }
                    return namespaces;
                };
                OrganizationService.prototype.setAttribute = function (namespaces, obj, attribute) {
                    if (attribute.nodeName == "xmlns") {
                        namespaces["_"] = attribute.nodeValue;
                    }
                    else {
                        var nsMatch = /xmlns:(\w)/.exec(attribute.nodeName);
                        if (nsMatch) {
                            namespaces[nsMatch[1]] = attribute.nodeValue;
                        }
                    }
                    obj["@" + attribute.nodeName] = attribute.nodeValue;
                };
                OrganizationService.prototype.setChildren = function (namespaces, obj, node) {
                    var _this = this;
                    if (node.hasChildNodes()) {
                        _.each(node.childNodes, function (item) {
                            if (item.nodeType == 3) {
                                obj[item.nodeName] = (obj[item.nodeName] ? obj[item.nodeName] : "") + item.nodeValue;
                            }
                            else {
                                var child = _this.toObject(namespaces, item);
                                var name = child["_name"];
                                if (typeof (obj[name]) == "undefined") {
                                    obj[name] = [];
                                }
                                obj[name].push(child);
                            }
                        });
                    }
                };
                OrganizationService.prototype.getXmlName = function (name) {
                    var results = /(\w):(.{1,})/.exec(name);
                    return (results && results.length > 2) ? { ns: results[1], name: results[2] } : { ns: "_", name: name };
                };
                OrganizationService.prototype.getCrmClientUrl = function () {
                    var context;
                    var serverUrl;
                    if (typeof GetGlobalContext != "undefined") {
                        context = GetGlobalContext();
                    }
                    else {
                        if (typeof Xrm != "undefined") {
                            context = Xrm.Page.context;
                        }
                        else {
                            throw new Error("Context is not available.");
                        }
                    }
                    if (typeof context.getClientUrl == 'function') {
                        serverUrl = context.getClientUrl(); // UR12+
                    }
                    else {
                        serverUrl = context.getServerUrl();
                    }
                    if (serverUrl.match(/\/$/)) {
                        serverUrl = serverUrl.substring(0, serverUrl.length - 1);
                    }
                    return serverUrl;
                };
                OrganizationService.prototype.getCrmClientOrgUrl = function () {
                    return this.getCrmClientUrl() + "/XRMServices/2011/Organization.svc/web";
                };
                return OrganizationService;
            })();
            client.OrganizationService = OrganizationService;
        })(client = sdk.client || (sdk.client = {}));
        var metadata;
        (function (metadata) {
            (function (EntityFilters) {
                EntityFilters[EntityFilters["Entity"] = 1] = "Entity";
                EntityFilters[EntityFilters["Attributes"] = 2] = "Attributes";
                EntityFilters[EntityFilters["Privileges"] = 4] = "Privileges";
                EntityFilters[EntityFilters["Relationships"] = 8] = "Relationships";
                EntityFilters[EntityFilters["All"] = 15] = "All";
            })(metadata.EntityFilters || (metadata.EntityFilters = {}));
            var EntityFilters = metadata.EntityFilters;
            (function (AttributeTypeCode) {
                AttributeTypeCode[AttributeTypeCode["Boolean"] = 0] = "Boolean";
                AttributeTypeCode[AttributeTypeCode["Customer"] = 1] = "Customer";
                AttributeTypeCode[AttributeTypeCode["DateTime"] = 2] = "DateTime";
                AttributeTypeCode[AttributeTypeCode["Decimal"] = 3] = "Decimal";
                AttributeTypeCode[AttributeTypeCode["Double"] = 4] = "Double";
                AttributeTypeCode[AttributeTypeCode["Integer"] = 5] = "Integer";
                AttributeTypeCode[AttributeTypeCode["Lookup"] = 6] = "Lookup";
                AttributeTypeCode[AttributeTypeCode["Memo"] = 7] = "Memo";
                AttributeTypeCode[AttributeTypeCode["Money"] = 8] = "Money";
                AttributeTypeCode[AttributeTypeCode["Owner"] = 9] = "Owner";
                AttributeTypeCode[AttributeTypeCode["PartyList"] = 10] = "PartyList";
                AttributeTypeCode[AttributeTypeCode["Picklist"] = 11] = "Picklist";
                AttributeTypeCode[AttributeTypeCode["State"] = 12] = "State";
                AttributeTypeCode[AttributeTypeCode["Status"] = 13] = "Status";
                AttributeTypeCode[AttributeTypeCode["String"] = 14] = "String";
                AttributeTypeCode[AttributeTypeCode["Uniqueidentifier"] = 15] = "Uniqueidentifier";
                AttributeTypeCode[AttributeTypeCode["CalendarRules"] = 16] = "CalendarRules";
                AttributeTypeCode[AttributeTypeCode["Virtual"] = 17] = "Virtual";
                AttributeTypeCode[AttributeTypeCode["BigInt"] = 18] = "BigInt";
                AttributeTypeCode[AttributeTypeCode["ManagedProperty"] = 19] = "ManagedProperty";
                AttributeTypeCode[AttributeTypeCode["EntityName"] = 20] = "EntityName";
            })(metadata.AttributeTypeCode || (metadata.AttributeTypeCode = {}));
            var AttributeTypeCode = metadata.AttributeTypeCode;
            (function (OwnershipTypes) {
                OwnershipTypes[OwnershipTypes["None"] = 0] = "None";
                OwnershipTypes[OwnershipTypes["UserOwned"] = 1] = "UserOwned";
                OwnershipTypes[OwnershipTypes["TeamOwned"] = 2] = "TeamOwned";
                OwnershipTypes[OwnershipTypes["BusinessOwned"] = 4] = "BusinessOwned";
                OwnershipTypes[OwnershipTypes["OrganizationOwned"] = 8] = "OrganizationOwned";
                OwnershipTypes[OwnershipTypes["BusinessParented"] = 16] = "BusinessParented";
            })(metadata.OwnershipTypes || (metadata.OwnershipTypes = {}));
            var OwnershipTypes = metadata.OwnershipTypes;
            (function (ImeMode) {
                ImeMode[ImeMode["Auto"] = 0] = "Auto";
                ImeMode[ImeMode["Inactive"] = 1] = "Inactive";
                ImeMode[ImeMode["Active"] = 2] = "Active";
                ImeMode[ImeMode["Disabled"] = 3] = "Disabled";
            })(metadata.ImeMode || (metadata.ImeMode = {}));
            var ImeMode = metadata.ImeMode;
            (function (AttributeRequiredLevel) {
                AttributeRequiredLevel[AttributeRequiredLevel["None"] = 0] = "None";
                AttributeRequiredLevel[AttributeRequiredLevel["SystemRequired"] = 1] = "SystemRequired";
                AttributeRequiredLevel[AttributeRequiredLevel["ApplicationRequired"] = 2] = "ApplicationRequired";
                AttributeRequiredLevel[AttributeRequiredLevel["Recommended"] = 3] = "Recommended";
            })(metadata.AttributeRequiredLevel || (metadata.AttributeRequiredLevel = {}));
            var AttributeRequiredLevel = metadata.AttributeRequiredLevel;
            (function (DateTimeFormat) {
                DateTimeFormat[DateTimeFormat["DateOnly"] = 0] = "DateOnly";
                DateTimeFormat[DateTimeFormat["DateAndTime"] = 1] = "DateAndTime";
            })(metadata.DateTimeFormat || (metadata.DateTimeFormat = {}));
            var DateTimeFormat = metadata.DateTimeFormat;
            (function (IntegerFormat) {
                IntegerFormat[IntegerFormat["None"] = 0] = "None";
                IntegerFormat[IntegerFormat["Duration"] = 1] = "Duration";
                IntegerFormat[IntegerFormat["TimeZone"] = 2] = "TimeZone";
                IntegerFormat[IntegerFormat["Language"] = 3] = "Language";
                IntegerFormat[IntegerFormat["Locale"] = 4] = "Locale";
            })(metadata.IntegerFormat || (metadata.IntegerFormat = {}));
            var IntegerFormat = metadata.IntegerFormat;
            (function (StringFormat) {
                StringFormat[StringFormat["Email"] = 0] = "Email";
                StringFormat[StringFormat["Text"] = 1] = "Text";
                StringFormat[StringFormat["TextArea"] = 2] = "TextArea";
                StringFormat[StringFormat["Url"] = 3] = "Url";
                StringFormat[StringFormat["TickerSymbol"] = 4] = "TickerSymbol";
                StringFormat[StringFormat["PhoneticGuide"] = 5] = "PhoneticGuide";
                StringFormat[StringFormat["VersionNumber"] = 6] = "VersionNumber";
                StringFormat[StringFormat["Phone"] = 7] = "Phone";
            })(metadata.StringFormat || (metadata.StringFormat = {}));
            var StringFormat = metadata.StringFormat;
            var MetadataBase = (function () {
                function MetadataBase() {
                }
                MetadataBase.prototype.fromSoap = function (data) {
                    adx.sdk.util.fromSoapBoolean(this, data, "hasChanged");
                };
                return MetadataBase;
            })();
            metadata.MetadataBase = MetadataBase;
            var EntityMetadata = (function (_super) {
                __extends(EntityMetadata, _super);
                function EntityMetadata() {
                    _super.apply(this, arguments);
                }
                EntityMetadata.prototype.fromSoap = function (data) {
                    _super.prototype.fromSoap.call(this, data);
                    adx.sdk.util.fromSoapNumber(this, data, "activityTypeMask", "objectTypeCode");
                    adx.sdk.util.fromSoapBoolean(this, data, "autoCreateAccessTeams", "autoRouteToOwnerQueue", "canTriggerWorkflow", "isDocumentManagementEnabled", "isAIRUpdated", "isActivity", "isActivityParty", "isAvailableOffline", "isBusinessProcessEnabled", "isChildEntity", "isCustomEntity", "isImportable", "isIntersect", "isManaged", "isQuickCreateEnabled", "isEnabledForCharts", "isEnabledForTrace", "isValidForAdvancedFind", "isReadingPaneEnabled");
                    adx.sdk.util.fromSoapEnum(this, data, "ownershipType", OwnershipTypes);
                    adx.sdk.util.fromSoapArrayProperty(this, data, "attributes", "AttributeMetadata");
                    adx.sdk.util.fromSoapArrayProperty(this, data, "manyToManyRelationships", "ManyToManyRelationshipMetadata");
                    adx.sdk.util.fromSoapArrayProperty(this, data, "manyToOneRelationships", "OneToManyRelationshipMetadata");
                    adx.sdk.util.fromSoapArrayProperty(this, data, "oneToManyRelationships", "OneToManyRelationshipMetadata");
                    adx.sdk.util.fromSoapArrayProperty(this, data, "privileges", "SecurityPrivilegeMetadata");
                };
                EntityMetadata.prototype.getAttribute = function (logicalName) {
                    var map = this.attributes["_map"];
                    return typeof (map) != "undefined"
                        ? map[logicalName]
                        : _.find(this.attributes, function (item) { return item.logicalName == logicalName; });
                };
                EntityMetadata._namespace = adx.sdk._xmlns.d;
                return EntityMetadata;
            })(MetadataBase);
            metadata.EntityMetadata = EntityMetadata;
            var ManagedProperty = (function () {
                function ManagedProperty(value, managedPropertyLogicalName, canBeChanged) {
                    if (canBeChanged === void 0) { canBeChanged = true; }
                    this.value = value;
                    this.managedPropertyLogicalName = managedPropertyLogicalName;
                    this.canBeChanged = canBeChanged;
                }
                ManagedProperty.prototype.toSoap = function () {
                    return [
                        "<a:CanBeChanged>" + _.escape(this.canBeChanged) + "</a:CanBeChanged>",
                        (this.managedPropertyLogicalName ? "<a:ManagedPropertyLogicalName>" + _.escape(this.managedPropertyLogicalName) + "</a:ManagedPropertyLogicalName>" : "<a:ManagedPropertyLogicalName i:nil='true' />"),
                        (this.value ? "<a:Value>" + _.escape(this.value) + "</a:Value>" : "<a:Value i:nil='true' />"),
                    ].join("");
                };
                ManagedProperty.prototype.fromSoap = function (data) {
                    adx.sdk.util.fromSoapBoolean(this, data, "canBeChanged");
                };
                ManagedProperty._namespace = adx.sdk._xmlns.a;
                return ManagedProperty;
            })();
            metadata.ManagedProperty = ManagedProperty;
            var BooleanManagedProperty = (function (_super) {
                __extends(BooleanManagedProperty, _super);
                function BooleanManagedProperty(value, logicalName) {
                    if (value === void 0) { value = null; }
                    if (logicalName === void 0) { logicalName = null; }
                    _super.call(this, value, logicalName);
                }
                BooleanManagedProperty.prototype.fromSoap = function (data) {
                    _super.prototype.fromSoap.call(this, data);
                    adx.sdk.util.fromSoapBoolean(this, data, "value");
                };
                BooleanManagedProperty._namespace = adx.sdk._xmlns.a;
                return BooleanManagedProperty;
            })(ManagedProperty);
            metadata.BooleanManagedProperty = BooleanManagedProperty;
            var AttributeRequiredLevelManagedProperty = (function (_super) {
                __extends(AttributeRequiredLevelManagedProperty, _super);
                function AttributeRequiredLevelManagedProperty(value, logicalName) {
                    if (value === void 0) { value = null; }
                    if (logicalName === void 0) { logicalName = null; }
                    _super.call(this, value, logicalName);
                }
                AttributeRequiredLevelManagedProperty.prototype.fromSoap = function (data) {
                    _super.prototype.fromSoap.call(this, data);
                    adx.sdk.util.fromSoapEnum(this, data, "value", AttributeRequiredLevel);
                };
                AttributeRequiredLevelManagedProperty._namespace = adx.sdk._xmlns.a;
                return AttributeRequiredLevelManagedProperty;
            })(ManagedProperty);
            metadata.AttributeRequiredLevelManagedProperty = AttributeRequiredLevelManagedProperty;
            var Label = (function () {
                function Label() {
                }
                Label.prototype.fromSoap = function (data) {
                    adx.sdk.util.fromSoapArrayProperty(this, data, "localizedLabels", "LocalizedLabels");
                };
                Label._namespace = adx.sdk._xmlns.d;
                return Label;
            })();
            metadata.Label = Label;
            var LocalizedLabel = (function (_super) {
                __extends(LocalizedLabel, _super);
                function LocalizedLabel() {
                    _super.apply(this, arguments);
                }
                LocalizedLabel.prototype.fromSoap = function (data) {
                    _super.prototype.fromSoap.call(this, data);
                    adx.sdk.util.fromSoapBoolean(this, data, "isManaged");
                    adx.sdk.util.fromSoapNumber(this, data, "languageCode");
                };
                LocalizedLabel._namespace = adx.sdk._xmlns.d;
                return LocalizedLabel;
            })(MetadataBase);
            metadata.LocalizedLabel = LocalizedLabel;
            var AttributeMetadata = (function (_super) {
                __extends(AttributeMetadata, _super);
                function AttributeMetadata() {
                    _super.apply(this, arguments);
                }
                AttributeMetadata.prototype.fromSoap = function (data) {
                    _super.prototype.fromSoap.call(this, data);
                    adx.sdk.util.fromSoapBoolean(this, data, "isCustomAttribute", "isPrimaryId", "isPrimaryName", "isValidForCreate", "isValidForRead", "isValidForUpdate", "canBeSecuredForRead", "canBeSecuredForCreate", "canBeSecuredForUpdate", "isSecured", "isManaged");
                    adx.sdk.util.fromSoapNumber(this, data, "columnNumber");
                    adx.sdk.util.fromSoapObject(this, data, "attributeTypeName", new AttributeTypeDisplayName(null));
                    adx.sdk.util.fromSoapObject(this, data, "requiredLevel", new AttributeRequiredLevelManagedProperty(null, null));
                    adx.sdk.util.fromSoapEnum(this, data, "attributeType", AttributeTypeCode);
                };
                AttributeMetadata._namespace = adx.sdk._xmlns.d;
                return AttributeMetadata;
            })(MetadataBase);
            metadata.AttributeMetadata = AttributeMetadata;
            var EnumAttributeMetadata = (function (_super) {
                __extends(EnumAttributeMetadata, _super);
                function EnumAttributeMetadata() {
                    _super.apply(this, arguments);
                }
                EnumAttributeMetadata.prototype.fromSoap = function (data) {
                    _super.prototype.fromSoap.call(this, data);
                    adx.sdk.util.fromSoapNumber(this, data, "defaultFormValue");
                };
                EnumAttributeMetadata._namespace = adx.sdk._xmlns.d;
                return EnumAttributeMetadata;
            })(AttributeMetadata);
            metadata.EnumAttributeMetadata = EnumAttributeMetadata;
            var DoubleAttributeMetadata = (function (_super) {
                __extends(DoubleAttributeMetadata, _super);
                function DoubleAttributeMetadata() {
                    _super.apply(this, arguments);
                }
                DoubleAttributeMetadata.prototype.fromSoap = function (data) {
                    _super.prototype.fromSoap.call(this, data);
                    adx.sdk.util.fromSoapNumber(this, data, "maxValue", "minValue", "precision");
                    adx.sdk.util.fromSoapEnum(this, data, "imeMode", ImeMode);
                };
                DoubleAttributeMetadata._namespace = adx.sdk._xmlns.d;
                DoubleAttributeMetadata.minSupportedValue = -100000000000.0;
                DoubleAttributeMetadata.maxSupportedValue = 100000000000.0;
                DoubleAttributeMetadata.minSupportedPrecision = 0;
                DoubleAttributeMetadata.maxSupportedPrecision = 5;
                return DoubleAttributeMetadata;
            })(AttributeMetadata);
            metadata.DoubleAttributeMetadata = DoubleAttributeMetadata;
            var StateAttributeMetadata = (function (_super) {
                __extends(StateAttributeMetadata, _super);
                function StateAttributeMetadata() {
                    _super.apply(this, arguments);
                }
                StateAttributeMetadata._namespace = adx.sdk._xmlns.d;
                return StateAttributeMetadata;
            })(EnumAttributeMetadata);
            metadata.StateAttributeMetadata = StateAttributeMetadata;
            var LookupAttributeMetadata = (function (_super) {
                __extends(LookupAttributeMetadata, _super);
                function LookupAttributeMetadata() {
                    _super.apply(this, arguments);
                }
                LookupAttributeMetadata.prototype.fromSoap = function (data) {
                    _super.prototype.fromSoap.call(this, data);
                    adx.sdk.util.fromSoapArrayProperty(this, data, "targets", "string");
                };
                LookupAttributeMetadata._namespace = adx.sdk._xmlns.d;
                return LookupAttributeMetadata;
            })(AttributeMetadata);
            metadata.LookupAttributeMetadata = LookupAttributeMetadata;
            var BooleanAttributeMetadata = (function (_super) {
                __extends(BooleanAttributeMetadata, _super);
                function BooleanAttributeMetadata() {
                    _super.apply(this, arguments);
                }
                BooleanAttributeMetadata.prototype.fromSoap = function (data) {
                    _super.prototype.fromSoap.call(this, data);
                    adx.sdk.util.fromSoapBoolean(this, data, "defaultValue");
                };
                BooleanAttributeMetadata._namespace = adx.sdk._xmlns.d;
                return BooleanAttributeMetadata;
            })(AttributeMetadata);
            metadata.BooleanAttributeMetadata = BooleanAttributeMetadata;
            var DateTimeAttributeMetadata = (function (_super) {
                __extends(DateTimeAttributeMetadata, _super);
                function DateTimeAttributeMetadata() {
                    _super.apply(this, arguments);
                }
                DateTimeAttributeMetadata.prototype.fromSoap = function (data) {
                    _super.prototype.fromSoap.call(this, data);
                    adx.sdk.util.fromSoapEnum(this, data, "imeMode", ImeMode);
                    adx.sdk.util.fromSoapEnum(this, data, "format", DateTimeFormat);
                };
                DateTimeAttributeMetadata._namespace = adx.sdk._xmlns.d;
                DateTimeAttributeMetadata.minSupportedValue = new adx.sdk.DateTime("1900-01-01 00:00:00Z");
                DateTimeAttributeMetadata.maxSupportedValue = new adx.sdk.DateTime("9999-12-30 23:59:59Z");
                return DateTimeAttributeMetadata;
            })(AttributeMetadata);
            metadata.DateTimeAttributeMetadata = DateTimeAttributeMetadata;
            var DecimalAttributeMetadata = (function (_super) {
                __extends(DecimalAttributeMetadata, _super);
                function DecimalAttributeMetadata() {
                    _super.apply(this, arguments);
                }
                DecimalAttributeMetadata.prototype.fromSoap = function (data) {
                    _super.prototype.fromSoap.call(this, data);
                    adx.sdk.util.fromSoapNumber(this, data, "maxValue", "minValue", "precision");
                    adx.sdk.util.fromSoapEnum(this, data, "imeMode", ImeMode);
                };
                DecimalAttributeMetadata._namespace = adx.sdk._xmlns.d;
                DecimalAttributeMetadata.minSupportedValue = -100000000000.0;
                DecimalAttributeMetadata.maxSupportedValue = 100000000000.0;
                DecimalAttributeMetadata.minSupportedPrecision = 0;
                DecimalAttributeMetadata.maxSupportedPrecision = 10;
                return DecimalAttributeMetadata;
            })(AttributeMetadata);
            metadata.DecimalAttributeMetadata = DecimalAttributeMetadata;
            var EntityNameAttributeMetadata = (function (_super) {
                __extends(EntityNameAttributeMetadata, _super);
                function EntityNameAttributeMetadata() {
                    _super.apply(this, arguments);
                }
                EntityNameAttributeMetadata._namespace = adx.sdk._xmlns.d;
                return EntityNameAttributeMetadata;
            })(EnumAttributeMetadata);
            metadata.EntityNameAttributeMetadata = EntityNameAttributeMetadata;
            var IntegerAttributeMetadata = (function (_super) {
                __extends(IntegerAttributeMetadata, _super);
                function IntegerAttributeMetadata() {
                    _super.apply(this, arguments);
                }
                IntegerAttributeMetadata.prototype.fromSoap = function (data) {
                    _super.prototype.fromSoap.call(this, data);
                    adx.sdk.util.fromSoapNumber(this, data, "maxValue", "minValue");
                    adx.sdk.util.fromSoapEnum(this, data, "format", IntegerFormat);
                };
                IntegerAttributeMetadata._namespace = adx.sdk._xmlns.d;
                IntegerAttributeMetadata.minSupportedValue = -2147483648;
                IntegerAttributeMetadata.maxSupportedValue = 2147483647;
                return IntegerAttributeMetadata;
            })(AttributeMetadata);
            metadata.IntegerAttributeMetadata = IntegerAttributeMetadata;
            var BigIntAttributeMetadata = (function (_super) {
                __extends(BigIntAttributeMetadata, _super);
                function BigIntAttributeMetadata() {
                    _super.apply(this, arguments);
                }
                BigIntAttributeMetadata.prototype.fromSoap = function (data) {
                    _super.prototype.fromSoap.call(this, data);
                    adx.sdk.util.fromSoapNumber(this, data, "maxValue", "minValue");
                };
                BigIntAttributeMetadata._namespace = adx.sdk._xmlns.d;
                BigIntAttributeMetadata.minSupportedValue = -9223372036854775808;
                BigIntAttributeMetadata.maxSupportedValue = 9223372036854775807;
                return BigIntAttributeMetadata;
            })(AttributeMetadata);
            metadata.BigIntAttributeMetadata = BigIntAttributeMetadata;
            var StatusAttributeMetadata = (function (_super) {
                __extends(StatusAttributeMetadata, _super);
                function StatusAttributeMetadata() {
                    _super.apply(this, arguments);
                }
                StatusAttributeMetadata._namespace = adx.sdk._xmlns.d;
                return StatusAttributeMetadata;
            })(EnumAttributeMetadata);
            metadata.StatusAttributeMetadata = StatusAttributeMetadata;
            var MemoAttributeMetadata = (function (_super) {
                __extends(MemoAttributeMetadata, _super);
                function MemoAttributeMetadata() {
                    _super.apply(this, arguments);
                }
                MemoAttributeMetadata.prototype.fromSoap = function (data) {
                    _super.prototype.fromSoap.call(this, data);
                    adx.sdk.util.fromSoapNumber(this, data, "maxLength");
                    adx.sdk.util.fromSoapEnum(this, data, "imeMode", ImeMode);
                    adx.sdk.util.fromSoapEnum(this, data, "format", StringFormat);
                };
                MemoAttributeMetadata._namespace = adx.sdk._xmlns.d;
                MemoAttributeMetadata.minSupportedLength = 1;
                MemoAttributeMetadata.maxSupportedLength = 1048576;
                return MemoAttributeMetadata;
            })(AttributeMetadata);
            metadata.MemoAttributeMetadata = MemoAttributeMetadata;
            var MoneyAttributeMetadata = (function (_super) {
                __extends(MoneyAttributeMetadata, _super);
                function MoneyAttributeMetadata() {
                    _super.apply(this, arguments);
                }
                MoneyAttributeMetadata.prototype.fromSoap = function (data) {
                    _super.prototype.fromSoap.call(this, data);
                    adx.sdk.util.fromSoapNumber(this, data, "maxValue", "minValue", "precision", "precisionSource");
                    adx.sdk.util.fromSoapEnum(this, data, "imeMode", ImeMode);
                };
                MoneyAttributeMetadata._namespace = adx.sdk._xmlns.d;
                MoneyAttributeMetadata.minSupportedValue = -922337203685477.0;
                MoneyAttributeMetadata.maxSupportedValue = 922337203685477.0;
                MoneyAttributeMetadata.minSupportedPrecision = 0;
                MoneyAttributeMetadata.maxSupportedPrecision = 4;
                return MoneyAttributeMetadata;
            })(AttributeMetadata);
            metadata.MoneyAttributeMetadata = MoneyAttributeMetadata;
            var PicklistAttributeMetadata = (function (_super) {
                __extends(PicklistAttributeMetadata, _super);
                function PicklistAttributeMetadata() {
                    _super.apply(this, arguments);
                }
                PicklistAttributeMetadata._namespace = adx.sdk._xmlns.d;
                return PicklistAttributeMetadata;
            })(EnumAttributeMetadata);
            metadata.PicklistAttributeMetadata = PicklistAttributeMetadata;
            var ManagedPropertyAttributeMetadata = (function (_super) {
                __extends(ManagedPropertyAttributeMetadata, _super);
                function ManagedPropertyAttributeMetadata() {
                    _super.apply(this, arguments);
                }
                ManagedPropertyAttributeMetadata.prototype.fromSoap = function (data) {
                    _super.prototype.fromSoap.call(this, data);
                    adx.sdk.util.fromSoapNumber(this, data, "parentComponentType");
                    adx.sdk.util.fromSoapEnum(this, data, "valueAttributeTypeCode", AttributeTypeCode);
                };
                ManagedPropertyAttributeMetadata._namespace = adx.sdk._xmlns.d;
                ManagedPropertyAttributeMetadata.emptyParentComponentType = 0;
                return ManagedPropertyAttributeMetadata;
            })(AttributeMetadata);
            metadata.ManagedPropertyAttributeMetadata = ManagedPropertyAttributeMetadata;
            var StringAttributeMetadata = (function (_super) {
                __extends(StringAttributeMetadata, _super);
                function StringAttributeMetadata() {
                    _super.apply(this, arguments);
                }
                StringAttributeMetadata.prototype.fromSoap = function (data) {
                    _super.prototype.fromSoap.call(this, data);
                    adx.sdk.util.fromSoapNumber(this, data, "maxLength");
                    adx.sdk.util.fromSoapObject(this, data, "formatName", new StringFormatName(null));
                    adx.sdk.util.fromSoapEnum(this, data, "imeMode", ImeMode);
                    adx.sdk.util.fromSoapEnum(this, data, "format", StringFormat);
                };
                StringAttributeMetadata._namespace = adx.sdk._xmlns.d;
                StringAttributeMetadata.minSupportedLength = 1;
                StringAttributeMetadata.maxSupportedLength = 4000;
                return StringAttributeMetadata;
            })(AttributeMetadata);
            metadata.StringAttributeMetadata = StringAttributeMetadata;
            var OptionSetMetadataBase = (function (_super) {
                __extends(OptionSetMetadataBase, _super);
                function OptionSetMetadataBase() {
                    _super.apply(this, arguments);
                }
                OptionSetMetadataBase.prototype.fromSoap = function (data) {
                    _super.prototype.fromSoap.call(this, data);
                    adx.sdk.util.fromSoapBoolean(this, data, "isCustomOptionSet", "isCustomizable", "isGlobal");
                };
                return OptionSetMetadataBase;
            })(MetadataBase);
            metadata.OptionSetMetadataBase = OptionSetMetadataBase;
            var OptionSetMetadata = (function (_super) {
                __extends(OptionSetMetadata, _super);
                function OptionSetMetadata() {
                    _super.apply(this, arguments);
                }
                OptionSetMetadata.prototype.fromSoap = function (data) {
                    _super.prototype.fromSoap.call(this, data);
                    adx.sdk.util.fromSoapArrayProperty(this, data, "options", "OptionMetadata");
                };
                OptionSetMetadata._namespace = adx.sdk._xmlns.d;
                return OptionSetMetadata;
            })(OptionSetMetadataBase);
            metadata.OptionSetMetadata = OptionSetMetadata;
            var BooleanOptionSetMetadata = (function (_super) {
                __extends(BooleanOptionSetMetadata, _super);
                function BooleanOptionSetMetadata() {
                    _super.apply(this, arguments);
                }
                BooleanOptionSetMetadata._namespace = adx.sdk._xmlns.d;
                return BooleanOptionSetMetadata;
            })(OptionSetMetadataBase);
            metadata.BooleanOptionSetMetadata = BooleanOptionSetMetadata;
            var OptionMetadata = (function (_super) {
                __extends(OptionMetadata, _super);
                function OptionMetadata() {
                    _super.apply(this, arguments);
                }
                OptionMetadata.prototype.fromSoap = function (data) {
                    _super.prototype.fromSoap.call(this, data);
                    adx.sdk.util.fromSoapBoolean(this, data, "isManaged");
                    adx.sdk.util.fromSoapNumber(this, data, "value");
                };
                OptionMetadata._namespace = adx.sdk._xmlns.d;
                return OptionMetadata;
            })(MetadataBase);
            metadata.OptionMetadata = OptionMetadata;
            var StateOptionMetadata = (function (_super) {
                __extends(StateOptionMetadata, _super);
                function StateOptionMetadata() {
                    _super.apply(this, arguments);
                }
                StateOptionMetadata.prototype.fromSoap = function (data) {
                    _super.prototype.fromSoap.call(this, data);
                    adx.sdk.util.fromSoapNumber(this, data, "defaultStatus");
                };
                StateOptionMetadata._namespace = adx.sdk._xmlns.d;
                return StateOptionMetadata;
            })(OptionMetadata);
            metadata.StateOptionMetadata = StateOptionMetadata;
            var StatusOptionMetadata = (function (_super) {
                __extends(StatusOptionMetadata, _super);
                function StatusOptionMetadata() {
                    _super.apply(this, arguments);
                }
                StatusOptionMetadata.prototype.fromSoap = function (data) {
                    _super.prototype.fromSoap.call(this, data);
                    adx.sdk.util.fromSoapNumber(this, data, "state");
                };
                StatusOptionMetadata._namespace = adx.sdk._xmlns.d;
                return StatusOptionMetadata;
            })(OptionMetadata);
            metadata.StatusOptionMetadata = StatusOptionMetadata;
            var RelationshipMetadataBase = (function (_super) {
                __extends(RelationshipMetadataBase, _super);
                function RelationshipMetadataBase() {
                    _super.apply(this, arguments);
                }
                RelationshipMetadataBase.prototype.fromSoap = function (data) {
                    _super.prototype.fromSoap.call(this, data);
                    adx.sdk.util.fromSoapBoolean(this, data, "isCustomRelationship", "isValidForAdvancedFind", "isManaged");
                };
                return RelationshipMetadataBase;
            })(MetadataBase);
            metadata.RelationshipMetadataBase = RelationshipMetadataBase;
            var OneToManyRelationshipMetadata = (function (_super) {
                __extends(OneToManyRelationshipMetadata, _super);
                function OneToManyRelationshipMetadata() {
                    _super.apply(this, arguments);
                }
                OneToManyRelationshipMetadata._namespace = adx.sdk._xmlns.d;
                return OneToManyRelationshipMetadata;
            })(RelationshipMetadataBase);
            metadata.OneToManyRelationshipMetadata = OneToManyRelationshipMetadata;
            var ManyToManyRelationshipMetadata = (function (_super) {
                __extends(ManyToManyRelationshipMetadata, _super);
                function ManyToManyRelationshipMetadata() {
                    _super.apply(this, arguments);
                }
                ManyToManyRelationshipMetadata._namespace = adx.sdk._xmlns.d;
                return ManyToManyRelationshipMetadata;
            })(RelationshipMetadataBase);
            metadata.ManyToManyRelationshipMetadata = ManyToManyRelationshipMetadata;
            var CascadeConfiguration = (function () {
                function CascadeConfiguration() {
                }
                CascadeConfiguration._namespace = adx.sdk._xmlns.d;
                return CascadeConfiguration;
            })();
            metadata.CascadeConfiguration = CascadeConfiguration;
            var AssociatedMenuConfiguration = (function () {
                function AssociatedMenuConfiguration() {
                }
                AssociatedMenuConfiguration.prototype.fromSoap = function (data) {
                    adx.sdk.util.fromSoapNumber(this, data, "order");
                };
                AssociatedMenuConfiguration._namespace = adx.sdk._xmlns.d;
                return AssociatedMenuConfiguration;
            })();
            metadata.AssociatedMenuConfiguration = AssociatedMenuConfiguration;
            var SecurityPrivilegeMetadata = (function () {
                function SecurityPrivilegeMetadata() {
                }
                SecurityPrivilegeMetadata.prototype.fromSoap = function (data) {
                    adx.sdk.util.fromSoapBoolean(this, data, "canBeBasic", "canBeDeep", "canBeGlobal", "canBeLocal");
                };
                SecurityPrivilegeMetadata._namespace = adx.sdk._xmlns.d;
                return SecurityPrivilegeMetadata;
            })();
            metadata.SecurityPrivilegeMetadata = SecurityPrivilegeMetadata;
            var ConstantsBase = (function () {
                function ConstantsBase(value) {
                    this.value = value;
                }
                ConstantsBase._namespace = adx.sdk._xmlns.d;
                return ConstantsBase;
            })();
            metadata.ConstantsBase = ConstantsBase;
            var AttributeTypeDisplayName = (function (_super) {
                __extends(AttributeTypeDisplayName, _super);
                function AttributeTypeDisplayName(value) {
                    _super.call(this, value);
                }
                AttributeTypeDisplayName._namespace = adx.sdk._xmlns.d;
                return AttributeTypeDisplayName;
            })(ConstantsBase);
            metadata.AttributeTypeDisplayName = AttributeTypeDisplayName;
            var StringFormatName = (function (_super) {
                __extends(StringFormatName, _super);
                function StringFormatName(value) {
                    _super.call(this, value);
                }
                StringFormatName._namespace = adx.sdk._xmlns.d;
                return StringFormatName;
            })(ConstantsBase);
            metadata.StringFormatName = StringFormatName;
            var _activityParty = {
                "ActivityTypeMask": 1,
                "Attributes": [
                    { "AttributeType": 6, "LogicalName": "activityid", "EntityLogicalName": "activityparty", "SchemaName": "ActivityId" },
                    { "AttributeType": 15, "LogicalName": "activitypartyid", "EntityLogicalName": "activityparty", "SchemaName": "ActivityPartyId" },
                    { "AttributeType": 14, "LogicalName": "addressused", "EntityLogicalName": "activityparty", "SchemaName": "AddressUsed" },
                    { "AttributeType": 0, "LogicalName": "donotemail", "EntityLogicalName": "activityparty", "SchemaName": "DoNotEmail" },
                    { "AttributeType": 17, "LogicalName": "donotemailname", "EntityLogicalName": "activityparty", "SchemaName": "DoNotEmailName" },
                    { "AttributeType": 0, "LogicalName": "donotfax", "EntityLogicalName": "activityparty", "SchemaName": "DoNotFax" },
                    { "AttributeType": 17, "LogicalName": "donotfaxname", "EntityLogicalName": "activityparty", "SchemaName": "DoNotFaxName" },
                    { "AttributeType": 0, "LogicalName": "donotphone", "EntityLogicalName": "activityparty", "SchemaName": "DoNotPhone" },
                    { "AttributeType": 17, "LogicalName": "donotphonename", "EntityLogicalName": "activityparty", "SchemaName": "DoNotPhoneName" },
                    { "AttributeType": 0, "LogicalName": "donotpostalmail", "EntityLogicalName": "activityparty", "SchemaName": "DoNotPostalMail" },
                    { "AttributeType": 17, "LogicalName": "donotpostalmailname", "EntityLogicalName": "activityparty", "SchemaName": "DoNotPostalMailName" },
                    { "AttributeType": 4, "LogicalName": "effort", "EntityLogicalName": "activityparty", "SchemaName": "Effort" },
                    { "AttributeType": 14, "LogicalName": "exchangeentryid", "EntityLogicalName": "activityparty", "SchemaName": "ExchangeEntryId" },
                    { "AttributeType": 11, "LogicalName": "instancetypecode", "EntityLogicalName": "activityparty", "SchemaName": "InstanceTypeCode" },
                    { "AttributeType": 17, "LogicalName": "instancetypecodename", "EntityLogicalName": "activityparty", "SchemaName": "InstanceTypeCodeName" },
                    { "AttributeType": 0, "LogicalName": "ispartydeleted", "EntityLogicalName": "activityparty", "SchemaName": "IsPartyDeleted" },
                    { "AttributeType": 17, "LogicalName": "ispartydeletedname", "EntityLogicalName": "activityparty", "SchemaName": "IsPartyDeletedName" },
                    { "AttributeType": 9, "LogicalName": "ownerid", "EntityLogicalName": "activityparty", "SchemaName": "OwnerId" },
                    { "AttributeType": 20, "LogicalName": "owneridtype", "EntityLogicalName": "activityparty", "SchemaName": "OwnerIdType" },
                    { "AttributeType": 15, "LogicalName": "owningbusinessunit", "EntityLogicalName": "activityparty", "SchemaName": "OwningBusinessUnit" },
                    { "AttributeType": 15, "LogicalName": "owninguser", "EntityLogicalName": "activityparty", "SchemaName": "OwningUser" },
                    { "AttributeType": 11, "LogicalName": "participationtypemask", "EntityLogicalName": "activityparty", "SchemaName": "ParticipationTypeMask" },
                    { "AttributeType": 17, "LogicalName": "participationtypemaskname", "EntityLogicalName": "activityparty", "SchemaName": "ParticipationTypeMaskName" },
                    { "AttributeType": 6, "LogicalName": "partyid", "EntityLogicalName": "activityparty", "SchemaName": "PartyId" },
                    { "AttributeType": 14, "LogicalName": "partyidname", "EntityLogicalName": "activityparty", "SchemaName": "PartyIdName" },
                    { "AttributeType": 20, "LogicalName": "partyobjecttypecode", "EntityLogicalName": "activityparty", "SchemaName": "PartyObjectTypeCode" },
                    { "AttributeType": 6, "LogicalName": "resourcespecid", "EntityLogicalName": "activityparty", "SchemaName": "ResourceSpecId" },
                    { "AttributeType": 14, "LogicalName": "resourcespecidname", "EntityLogicalName": "activityparty", "SchemaName": "ResourceSpecIdName" },
                    { "AttributeType": 2, "LogicalName": "scheduledend", "EntityLogicalName": "activityparty", "SchemaName": "ScheduledEnd" },
                    { "AttributeType": 2, "LogicalName": "scheduledstart", "EntityLogicalName": "activityparty", "SchemaName": "ScheduledStart" },
                    { "AttributeType": 18, "LogicalName": "versionnumber", "EntityLogicalName": "activityparty", "SchemaName": "VersionNumber" }
                ],
                "LogicalName": "activityparty",
                "PrimaryNameAttribute": "partyidname",
                "PrimaryIdAttribute": "activitypartyid",
                "SchemaName": "ActivityParty"
            };
            metadata._activityPartyMetadata = adx.sdk.util.fromJson(_activityParty);
        })(metadata = sdk.metadata || (sdk.metadata = {}));
        var query;
        (function (query_1) {
            var QueryBase = (function () {
                function QueryBase() {
                }
                return QueryBase;
            })();
            query_1.QueryBase = QueryBase;
            var FetchExpression = (function (_super) {
                __extends(FetchExpression, _super);
                function FetchExpression(query) {
                    _super.call(this);
                    this.query = query;
                    this.query = query;
                }
                FetchExpression.prototype.toSoap = function () {
                    return [
                        "<a:Query>" + _.escape(this.query) + "</a:Query>",
                    ].join("");
                };
                FetchExpression._namespace = adx.sdk._xmlns.a;
                return FetchExpression;
            })(QueryBase);
            query_1.FetchExpression = FetchExpression;
            var ColumnSet = (function () {
                function ColumnSet(allColumns, columns) {
                    if (allColumns === void 0) { allColumns = false; }
                    if (columns === void 0) { columns = []; }
                    this.AllColumns = allColumns;
                    this.Columns = columns;
                }
                ColumnSet.prototype.toSoapFromColumns = function (columns) {
                    return _.map(columns, function (column) {
                        return "<c:string>" + column + "</c:string>";
                    }).join("");
                };
                ColumnSet.prototype.toSoap = function () {
                    if (this.AllColumns) {
                        return [
                            "<a:AllColumns>true</a:AllColumns>",
                            "<a:Columns xmlns:c ='http://schemas.microsoft.com/2003/10/Serialization/Arrays' />",
                        ].join("");
                    }
                    return [
                        "<a:AllColumns>false</a:AllColumns>",
                        "<a:Columns xmlns:c='http://schemas.microsoft.com/2003/10/Serialization/Arrays'>",
                        this.toSoapFromColumns(this.Columns),
                        "</a:Columns>"
                    ].join("");
                };
                ColumnSet._namespace = adx.sdk._xmlns.a;
                return ColumnSet;
            })();
            query_1.ColumnSet = ColumnSet;
        })(query = sdk.query || (sdk.query = {}));
        var messages;
        (function (messages) {
            var EntityFiltersProperty = (function () {
                function EntityFiltersProperty(value) {
                    this.value = value;
                }
                EntityFiltersProperty.prototype.toSoap = function () {
                    return adx.sdk.util.enumToString(this.value, adx.sdk.metadata.EntityFilters);
                };
                EntityFiltersProperty._namespace = adx.sdk._xmlns.d;
                EntityFiltersProperty._soapType = "EntityFilters";
                return EntityFiltersProperty;
            })();
            messages.EntityFiltersProperty = EntityFiltersProperty;
            var OrganizationRequest = (function (_super) {
                __extends(OrganizationRequest, _super);
                function OrganizationRequest(requestName) {
                    _super.call(this);
                    this.requestName = requestName;
                    this.parameters = {};
                }
                OrganizationRequest.prototype.toSoapEnvelope = function () {
                    return [
                        "<s:Envelope xmlns:s='http://schemas.xmlsoap.org/soap/envelope/'>",
                        "<s:Body>",
                        "<Execute xmlns='http://schemas.microsoft.com/xrm/2011/Contracts/Services' xmlns:i='http://www.w3.org/2001/XMLSchema-instance'>",
                        this.toSoap(),
                        "</Execute>",
                        "</s:Body>",
                        "</s:Envelope>"
                    ].join("");
                };
                OrganizationRequest.prototype.toSoap = function () {
                    var ns = adx.sdk.util.getNamespace(this);
                    var attribute = ns.prefix != adx.sdk._xmlns.a.prefix
                        ? " xmlns:" + ns.prefix + " = '" + ns.uri + "'"
                        : "";
                    return [
                        "<request i:type='" + ns.prefix + ":" + adx.sdk.util.getType(this) + "' xmlns:a='http://schemas.microsoft.com/xrm/2011/Contracts'" + attribute + ">",
                        this.toSoapFromParameters(this.parameters),
                        (this.requestId ? "<a:RequestId>" + _.escape(this.requestId) + "</a:RequestId>" : "<a:RequestId i:nil='true' />"),
                        "<a:RequestName>" + _.escape(this.requestName) + "</a:RequestName>",
                        "</request>",
                    ].join("");
                };
                OrganizationRequest.prototype.toSoapFromParameters = function (parameters) {
                    return [
                        "<a:Parameters xmlns:b='http://schemas.datacontract.org/2004/07/System.Collections.Generic'>",
                        this.toSoapFromCollection(parameters),
                        "</a:Parameters>",
                    ].join("");
                };
                return OrganizationRequest;
            })(SoapCollection);
            messages.OrganizationRequest = OrganizationRequest;
            var OrganizationResponse = (function () {
                function OrganizationResponse() {
                }
                return OrganizationResponse;
            })();
            messages.OrganizationResponse = OrganizationResponse;
            var RetrieveAllEntitiesRequest = (function (_super) {
                __extends(RetrieveAllEntitiesRequest, _super);
                function RetrieveAllEntitiesRequest(entityFilters, retrieveAsIfPublished) {
                    if (entityFilters === void 0) { entityFilters = adx.sdk.metadata.EntityFilters.Entity; }
                    if (retrieveAsIfPublished === void 0) { retrieveAsIfPublished = false; }
                    _super.call(this, "RetrieveAllEntities");
                    this.parameters = {
                        EntityFilters: new EntityFiltersProperty(entityFilters),
                        RetrieveAsIfPublished: retrieveAsIfPublished
                    };
                }
                RetrieveAllEntitiesRequest._namespace = adx.sdk._xmlns.a;
                return RetrieveAllEntitiesRequest;
            })(OrganizationRequest);
            messages.RetrieveAllEntitiesRequest = RetrieveAllEntitiesRequest;
            var RetrieveAllEntitiesResponse = (function (_super) {
                __extends(RetrieveAllEntitiesResponse, _super);
                function RetrieveAllEntitiesResponse() {
                    _super.apply(this, arguments);
                }
                RetrieveAllEntitiesResponse.prototype.getEntityMetadata = function () {
                    return this.results["EntityMetadata"];
                };
                RetrieveAllEntitiesResponse.prototype.getTimestamp = function () {
                    return this.results["Timestamp"];
                };
                RetrieveAllEntitiesResponse._namespace = adx.sdk._xmlns.a;
                return RetrieveAllEntitiesResponse;
            })(OrganizationResponse);
            messages.RetrieveAllEntitiesResponse = RetrieveAllEntitiesResponse;
            var RetrieveEntityRequest = (function (_super) {
                __extends(RetrieveEntityRequest, _super);
                function RetrieveEntityRequest(logicalName, entityFilters, retrieveAsIfPublished) {
                    if (entityFilters === void 0) { entityFilters = adx.sdk.metadata.EntityFilters.Entity; }
                    if (retrieveAsIfPublished === void 0) { retrieveAsIfPublished = false; }
                    _super.call(this, "RetrieveEntity");
                    this.parameters = {
                        MetadataId: adx.sdk.Guid.empty,
                        LogicalName: logicalName,
                        EntityFilters: new EntityFiltersProperty(entityFilters),
                        RetrieveAsIfPublished: retrieveAsIfPublished
                    };
                }
                RetrieveEntityRequest._namespace = adx.sdk._xmlns.a;
                return RetrieveEntityRequest;
            })(OrganizationRequest);
            messages.RetrieveEntityRequest = RetrieveEntityRequest;
            var RetrieveEntityResponse = (function (_super) {
                __extends(RetrieveEntityResponse, _super);
                function RetrieveEntityResponse() {
                    _super.apply(this, arguments);
                }
                RetrieveEntityResponse.prototype.getEntityMetadata = function () {
                    return this.results["EntityMetadata"];
                };
                RetrieveEntityResponse._namespace = adx.sdk._xmlns.a;
                return RetrieveEntityResponse;
            })(OrganizationResponse);
            messages.RetrieveEntityResponse = RetrieveEntityResponse;
            var RetrieveAttributeRequest = (function (_super) {
                __extends(RetrieveAttributeRequest, _super);
                function RetrieveAttributeRequest(entityLogicalName, logicalName, retrieveAsIfPublished) {
                    if (retrieveAsIfPublished === void 0) { retrieveAsIfPublished = false; }
                    _super.call(this, "RetrieveAttribute");
                    this.parameters = {
                        MetadataId: adx.sdk.Guid.empty,
                        EntityLogicalName: entityLogicalName,
                        LogicalName: logicalName,
                        RetrieveAsIfPublished: retrieveAsIfPublished
                    };
                }
                RetrieveAttributeRequest._namespace = adx.sdk._xmlns.a;
                return RetrieveAttributeRequest;
            })(OrganizationRequest);
            messages.RetrieveAttributeRequest = RetrieveAttributeRequest;
            var RetrieveAttributeResponse = (function (_super) {
                __extends(RetrieveAttributeResponse, _super);
                function RetrieveAttributeResponse() {
                    _super.apply(this, arguments);
                }
                RetrieveAttributeResponse.prototype.getEntityMetadata = function () {
                    return this.results["AttributeMetadata"];
                };
                RetrieveAttributeResponse._namespace = adx.sdk._xmlns.a;
                return RetrieveAttributeResponse;
            })(OrganizationResponse);
            messages.RetrieveAttributeResponse = RetrieveAttributeResponse;
            var RetrieveRelationshipRequest = (function (_super) {
                __extends(RetrieveRelationshipRequest, _super);
                function RetrieveRelationshipRequest(name, retrieveAsIfPublished) {
                    if (retrieveAsIfPublished === void 0) { retrieveAsIfPublished = false; }
                    _super.call(this, "RetrieveRelationship");
                    this.parameters = {
                        MetadataId: adx.sdk.Guid.empty,
                        Name: name,
                        RetrieveAsIfPublished: retrieveAsIfPublished
                    };
                }
                RetrieveRelationshipRequest._namespace = adx.sdk._xmlns.a;
                return RetrieveRelationshipRequest;
            })(OrganizationRequest);
            messages.RetrieveRelationshipRequest = RetrieveRelationshipRequest;
            var RetrieveRelationshipResponse = (function (_super) {
                __extends(RetrieveRelationshipResponse, _super);
                function RetrieveRelationshipResponse() {
                    _super.apply(this, arguments);
                }
                RetrieveRelationshipResponse.prototype.getEntityMetadata = function () {
                    return this.results["RelationshipMetadata"];
                };
                RetrieveRelationshipResponse._namespace = adx.sdk._xmlns.a;
                return RetrieveRelationshipResponse;
            })(OrganizationResponse);
            messages.RetrieveRelationshipResponse = RetrieveRelationshipResponse;
            var CreateRequest = (function (_super) {
                __extends(CreateRequest, _super);
                function CreateRequest(target) {
                    _super.call(this, "Create");
                    this.parameters = {
                        Target: target
                    };
                }
                CreateRequest._namespace = adx.sdk._xmlns.a;
                return CreateRequest;
            })(OrganizationRequest);
            messages.CreateRequest = CreateRequest;
            var CreateResponse = (function (_super) {
                __extends(CreateResponse, _super);
                function CreateResponse() {
                    _super.apply(this, arguments);
                }
                CreateResponse.prototype.getId = function () {
                    return this.results["id"];
                };
                CreateResponse._namespace = adx.sdk._xmlns.a;
                return CreateResponse;
            })(OrganizationResponse);
            messages.CreateResponse = CreateResponse;
            var UpdateRequest = (function (_super) {
                __extends(UpdateRequest, _super);
                function UpdateRequest(target) {
                    _super.call(this, "Update");
                    this.parameters = {
                        Target: target
                    };
                }
                UpdateRequest._namespace = adx.sdk._xmlns.a;
                return UpdateRequest;
            })(OrganizationRequest);
            messages.UpdateRequest = UpdateRequest;
            var UpdateResponse = (function (_super) {
                __extends(UpdateResponse, _super);
                function UpdateResponse() {
                    _super.apply(this, arguments);
                }
                UpdateResponse._namespace = adx.sdk._xmlns.a;
                return UpdateResponse;
            })(OrganizationResponse);
            messages.UpdateResponse = UpdateResponse;
            var DeleteRequest = (function (_super) {
                __extends(DeleteRequest, _super);
                function DeleteRequest(target) {
                    _super.call(this, "Delete");
                    this.parameters = {
                        Target: target
                    };
                }
                DeleteRequest._namespace = adx.sdk._xmlns.a;
                return DeleteRequest;
            })(OrganizationRequest);
            messages.DeleteRequest = DeleteRequest;
            var DeleteResponse = (function (_super) {
                __extends(DeleteResponse, _super);
                function DeleteResponse() {
                    _super.apply(this, arguments);
                }
                DeleteResponse._namespace = adx.sdk._xmlns.a;
                return DeleteResponse;
            })(OrganizationResponse);
            messages.DeleteResponse = DeleteResponse;
            var RetrieveRequest = (function (_super) {
                __extends(RetrieveRequest, _super);
                function RetrieveRequest(target, columnSet) {
                    if (columnSet === void 0) { columnSet = null; }
                    _super.call(this, "Retrieve");
                    this.parameters = {
                        Target: target,
                        ColumnSet: columnSet
                    };
                }
                RetrieveRequest._namespace = adx.sdk._xmlns.a;
                return RetrieveRequest;
            })(OrganizationRequest);
            messages.RetrieveRequest = RetrieveRequest;
            var RetrieveResponse = (function (_super) {
                __extends(RetrieveResponse, _super);
                function RetrieveResponse() {
                    _super.apply(this, arguments);
                }
                RetrieveResponse.prototype.getEntity = function () {
                    return this.results["Entity"];
                };
                RetrieveResponse._namespace = adx.sdk._xmlns.a;
                return RetrieveResponse;
            })(OrganizationResponse);
            messages.RetrieveResponse = RetrieveResponse;
            var RetrieveMultipleRequest = (function (_super) {
                __extends(RetrieveMultipleRequest, _super);
                function RetrieveMultipleRequest(query) {
                    _super.call(this, "RetrieveMultiple");
                    this.parameters = {
                        Query: query
                    };
                }
                RetrieveMultipleRequest._namespace = adx.sdk._xmlns.a;
                return RetrieveMultipleRequest;
            })(OrganizationRequest);
            messages.RetrieveMultipleRequest = RetrieveMultipleRequest;
            var RetrieveMultipleResponse = (function (_super) {
                __extends(RetrieveMultipleResponse, _super);
                function RetrieveMultipleResponse() {
                    _super.apply(this, arguments);
                }
                RetrieveMultipleResponse.prototype.getEntityCollection = function () {
                    return this.results["EntityCollection"];
                };
                RetrieveMultipleResponse._namespace = adx.sdk._xmlns.a;
                return RetrieveMultipleResponse;
            })(OrganizationResponse);
            messages.RetrieveMultipleResponse = RetrieveMultipleResponse;
            var WhoAmIRequest = (function (_super) {
                __extends(WhoAmIRequest, _super);
                function WhoAmIRequest() {
                    _super.call(this, "WhoAmI");
                }
                WhoAmIRequest._namespace = adx.sdk._xmlns.f;
                return WhoAmIRequest;
            })(OrganizationRequest);
            messages.WhoAmIRequest = WhoAmIRequest;
            var WhoAmIResponse = (function (_super) {
                __extends(WhoAmIResponse, _super);
                function WhoAmIResponse() {
                    _super.apply(this, arguments);
                }
                WhoAmIResponse.prototype.getUserId = function () {
                    return this.results["UserId"];
                };
                WhoAmIResponse.prototype.getBusinessUnitId = function () {
                    return this.results["BusinessUnitId"];
                };
                WhoAmIResponse.prototype.getOrganizationId = function () {
                    return this.results["OrganizationId"];
                };
                WhoAmIResponse._namespace = adx.sdk._xmlns.f;
                return WhoAmIResponse;
            })(OrganizationResponse);
            messages.WhoAmIResponse = WhoAmIResponse;
            var SetStateRequest = (function (_super) {
                __extends(SetStateRequest, _super);
                function SetStateRequest(entityMoniker, state, status) {
                    _super.call(this, "SetState");
                    this.parameters = {
                        EntityMoniker: entityMoniker,
                        State: state,
                        Status: status
                    };
                }
                SetStateRequest._namespace = adx.sdk._xmlns.f;
                return SetStateRequest;
            })(OrganizationRequest);
            messages.SetStateRequest = SetStateRequest;
            var SetStateResponse = (function (_super) {
                __extends(SetStateResponse, _super);
                function SetStateResponse() {
                    _super.apply(this, arguments);
                }
                SetStateResponse._namespace = adx.sdk._xmlns.f;
                return SetStateResponse;
            })(OrganizationResponse);
            messages.SetStateResponse = SetStateResponse;
            var AssociateRequest = (function (_super) {
                __extends(AssociateRequest, _super);
                function AssociateRequest(target, relationship, relatedEntities) {
                    _super.call(this, "Associate");
                    this.parameters = {
                        Target: target,
                        Relationship: relationship,
                        RelatedEntities: relatedEntities
                    };
                }
                AssociateRequest._namespace = adx.sdk._xmlns.a;
                return AssociateRequest;
            })(OrganizationRequest);
            messages.AssociateRequest = AssociateRequest;
            var AssociateResponse = (function (_super) {
                __extends(AssociateResponse, _super);
                function AssociateResponse() {
                    _super.apply(this, arguments);
                }
                AssociateResponse._namespace = adx.sdk._xmlns.a;
                return AssociateResponse;
            })(OrganizationResponse);
            messages.AssociateResponse = AssociateResponse;
            var DisassociateRequest = (function (_super) {
                __extends(DisassociateRequest, _super);
                function DisassociateRequest(target, relationship, relatedEntities) {
                    _super.call(this, "Disassociate");
                    this.parameters = {
                        Target: target,
                        Relationship: relationship,
                        RelatedEntities: relatedEntities
                    };
                }
                DisassociateRequest._namespace = adx.sdk._xmlns.a;
                return DisassociateRequest;
            })(OrganizationRequest);
            messages.DisassociateRequest = DisassociateRequest;
            var DisassociateResponse = (function (_super) {
                __extends(DisassociateResponse, _super);
                function DisassociateResponse() {
                    _super.apply(this, arguments);
                }
                DisassociateResponse._namespace = adx.sdk._xmlns.a;
                return DisassociateResponse;
            })(OrganizationResponse);
            messages.DisassociateResponse = DisassociateResponse;
            var CloseIncidentRequest = (function (_super) {
                __extends(CloseIncidentRequest, _super);
                function CloseIncidentRequest(incidentResolution, status) {
                    _super.call(this, "CloseIncident");
                    this.parameters = {
                        IncidentResolution: incidentResolution,
                        Status: status
                    };
                }
                CloseIncidentRequest._namespace = adx.sdk._xmlns.a;
                return CloseIncidentRequest;
            })(OrganizationRequest);
            messages.CloseIncidentRequest = CloseIncidentRequest;
            var CloseIncidentResponse = (function (_super) {
                __extends(CloseIncidentResponse, _super);
                function CloseIncidentResponse() {
                    _super.apply(this, arguments);
                }
                CloseIncidentResponse._namespace = adx.sdk._xmlns.a;
                return CloseIncidentResponse;
            })(OrganizationResponse);
            messages.CloseIncidentResponse = CloseIncidentResponse;
	    var ExecuteWorkflowRequest = (function (_super) {
                __extends(ExecuteWorkflowRequest, _super);
                function ExecuteWorkflowRequest(workflowId, entityId) {
                    _super.call(this, "ExecuteWorkflow");
                    this.parameters = {
                        WorkflowId: workflowId,
                        EntityId: entityId
                    };
                }
                ExecuteWorkflowRequest._namespace = adx.sdk._xmlns.f;
                return ExecuteWorkflowRequest;
            })(OrganizationRequest);
            messages.ExecuteWorkflowRequest = ExecuteWorkflowRequest;
            var ExecuteWorkflowResponse = (function (_super) {
                __extends(ExecuteWorkflowResponse, _super);
                function ExecuteWorkflowResponse() {
                    _super.apply(this, arguments);
                }
                ExecuteWorkflowResponse._namespace = adx.sdk._xmlns.f;
                return ExecuteWorkflowResponse;
            })(OrganizationResponse);
            messages.ExecuteWorkflowResponse = ExecuteWorkflowResponse;
            var WinOpportunityRequest = (function (_super) {
                __extends(WinOpportunityRequest, _super);
                function WinOpportunityRequest(opportunityClose, status) {
                    _super.call(this, "WinOpportunity");
                    this.parameters = {
                        OpportunityClose: opportunityClose,
                        Status: status
                    };
                }
                WinOpportunityRequest._namespace = adx.sdk._xmlns.a;
                return WinOpportunityRequest;
            })(OrganizationRequest);
            messages.WinOpportunityRequest = WinOpportunityRequest;
            var WinOpportunityResponse = (function (_super) {
                __extends(WinOpportunityResponse, _super);
                function WinOpportunityResponse() {
                    _super.apply(this, arguments);
                }
                WinOpportunityResponse._namespace = adx.sdk._xmlns.a;
                return WinOpportunityResponse;
            })(OrganizationResponse);
            messages.WinOpportunityResponse = WinOpportunityResponse;
            var LoseOpportunityRequest = (function (_super) {
                __extends(LoseOpportunityRequest, _super);
                function LoseOpportunityRequest(opportunityClose, status) {
                    _super.call(this, "LoseOpportunity");
                    this.parameters = {
                        OpportunityClose: opportunityClose,
                        Status: status
                    };
                }
                LoseOpportunityRequest._namespace = adx.sdk._xmlns.a;
                return LoseOpportunityRequest;
            })(OrganizationRequest);
            messages.LoseOpportunityRequest = LoseOpportunityRequest;
            var LoseOpportunityResponse = (function (_super) {
                __extends(LoseOpportunityResponse, _super);
                function LoseOpportunityResponse() {
                    _super.apply(this, arguments);
                }
                LoseOpportunityResponse._namespace = adx.sdk._xmlns.a;
                return LoseOpportunityResponse;
            })(OrganizationResponse);
            messages.LoseOpportunityResponse = LoseOpportunityResponse;
            var ImportSolutionRequest = (function (_super) {
                __extends(ImportSolutionRequest, _super);
                function ImportSolutionRequest(customizationFile, importJobId, overwriteUnmanagedCustomizations, publishWorkflows) {
                    if (importJobId === void 0) { importJobId = Guid.empty; }
                    if (overwriteUnmanagedCustomizations === void 0) { overwriteUnmanagedCustomizations = false; }
                    if (publishWorkflows === void 0) { publishWorkflows = false; }
                    _super.call(this, "ImportSolution");
                    this.parameters = {
                        CustomizationFile: customizationFile,
                        OverwriteUnmanagedCustomizations: overwriteUnmanagedCustomizations,
                        PublishWorkflows: publishWorkflows,
                        ImportJobId: importJobId
                    };
                }
                ImportSolutionRequest._namespace = adx.sdk._xmlns.f;
                return ImportSolutionRequest;
            })(OrganizationRequest);
            messages.ImportSolutionRequest = ImportSolutionRequest;
            var ImportSolutionResponse = (function (_super) {
                __extends(ImportSolutionResponse, _super);
                function ImportSolutionResponse() {
                    _super.apply(this, arguments);
                }
                ImportSolutionResponse._namespace = adx.sdk._xmlns.f;
                return ImportSolutionResponse;
            })(OrganizationResponse);
            messages.ImportSolutionResponse = ImportSolutionResponse;
            var RetrieveFormattedImportJobResultsRequest = (function (_super) {
                __extends(RetrieveFormattedImportJobResultsRequest, _super);
                function RetrieveFormattedImportJobResultsRequest(importJobId) {
                    _super.call(this, "RetrieveFormattedImportJobResults");
                    this.parameters = {
                        ImportJobId: importJobId
                    };
                }
                RetrieveFormattedImportJobResultsRequest._namespace = adx.sdk._xmlns.f;
                return RetrieveFormattedImportJobResultsRequest;
            })(OrganizationRequest);
            messages.RetrieveFormattedImportJobResultsRequest = RetrieveFormattedImportJobResultsRequest;
            var RetrieveFormattedImportJobResultsResponse = (function (_super) {
                __extends(RetrieveFormattedImportJobResultsResponse, _super);
                function RetrieveFormattedImportJobResultsResponse() {
                    _super.apply(this, arguments);
                }
                RetrieveFormattedImportJobResultsResponse._namespace = adx.sdk._xmlns.f;
                return RetrieveFormattedImportJobResultsResponse;
            })(OrganizationResponse);
            messages.RetrieveFormattedImportJobResultsResponse = RetrieveFormattedImportJobResultsResponse;
        })(messages = sdk.messages || (sdk.messages = {}));
    })(sdk = adx.sdk || (adx.sdk = {}));
})(adx || (adx = {}));
